/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques.PassiveTechniques;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.StatIDs;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.PassiveTechniques.PassiveTechnique;
import DaoOfModding.Cultivationcraft.StaminaHandler;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPose;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class ExpandingStomachTechnique
extends PassiveTechnique {
    protected final float maxXSize = 3.0f;
    protected final float maxYSize = 2.0f;
    protected final float maxZSize = 4.0f;
    protected int oldStamina = -1;
    protected float currentStamina = -1.0f;
    protected float currentPercent;
    protected boolean update = false;

    public ExpandingStomachTechnique() {
        this.langLocation = "cultivationcraft.technique.expandingstomach";
    }

    @Override
    public boolean isValid(Player player) {
        return CultivatorStats.getCultivatorStats(player).getCultivationType() == 1 && BodyModifications.getBodyModifications(player).hasOption("BODY", "STOMACH", "expandingStomach");
    }

    @Override
    public void tickClient(TickEvent.PlayerTickEvent event) {
        if (event.player == Minecraft.m_91087_().f_91074_) {
            this.currentStamina = StaminaHandler.getStamina(event.player);
        }
        this.updateSizeStats(event.player);
        if (this.update) {
            this.updateExpandingPose();
        }
        super.tickClient(event);
    }

    @Override
    public void tickServer(TickEvent.PlayerTickEvent event) {
        this.updateSizeStats(event.player);
        super.tickServer(event);
    }

    protected void updateSizeStats(Player player) {
        float foodPercent = this.currentStamina / StaminaHandler.getMaxStamina(player);
        if (this.currentPercent != foodPercent) {
            this.currentPercent = foodPercent;
            float weight = 0.5f * (2.0f * this.currentPercent + 1.0f * this.currentPercent + 3.0f * this.currentPercent);
            this.stats.setStat(StatIDs.weight, weight);
            BodyPartStatControl.updateStats(player);
            this.update = true;
            if (this.oldStamina != (int)this.currentStamina) {
                if (player.f_19853_.f_46443_ && Minecraft.m_91087_().f_91074_ == player) {
                    this.sendInfo((int)this.currentStamina);
                }
                this.oldStamina = (int)this.currentStamina;
            }
        }
    }

    @Override
    public void processInfo(Player player, int info) {
        this.currentStamina = info;
        this.oldStamina = info;
    }

    protected void updateExpandingPose() {
        this.pose = new PlayerPose();
        this.pose.addSize("Body", new Vec3((double)(1.0f + 2.0f * this.currentPercent), (double)(1.0f + 1.0f * this.currentPercent), (double)(1.0f + 3.0f * this.currentPercent)), 99, 5.0f);
    }
}

