/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques.PassiveTechniques;

import DaoOfModding.Cultivationcraft.Client.Physics;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.Quest;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.QuestHandler;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.PassiveTechniques.PassiveTechnique;
import DaoOfModding.Cultivationcraft.Common.Reflection;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPose;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class GlideTechnique
extends PassiveTechnique {
    PlayerPose jump = new PlayerPose();
    Vec3 prevMotion = new Vec3(0.0, 0.0, 0.0);

    public GlideTechnique() {
        this.langLocation = "cultivationcraft.technique.glide";
        this.jump.addAngle("Left_Arm", new Vec3(Math.toRadians(0.0), 0.0, Math.toRadians(-90.0)), 155);
        this.jump.addAngle("Right_Arm", new Vec3(Math.toRadians(0.0), 0.0, Math.toRadians(90.0)), 155);
    }

    @Override
    public boolean isValid(Player player) {
        return CultivatorStats.getCultivatorStats(player).getCultivationType() == 1 && BodyModifications.getBodyModifications(player).hasModification("ARM", "glidearm");
    }

    @Override
    public void tickClient(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_20096_() || player.m_20069_()) {
            return;
        }
        player.f_19789_ = 0.0f;
        float weightModifier = BodyPartStatControl.getPlayerStatControl(player).getFlightWeightModifier();
        float maxHorizontalSpeed = 0.75f;
        float horizontalSpeedIncrease = 0.025f * weightModifier;
        float minFallSpeed = -0.005f * (float)Math.pow(1.0f / weightModifier, 2.0);
        Vec3 currentMotion = Physics.getDelta(player);
        double horizontalSpeed = Math.abs(currentMotion.f_82479_) + Math.abs(currentMotion.f_82481_);
        double speedModifer = 0.0;
        if (horizontalSpeed < (double)maxHorizontalSpeed) {
            speedModifer = horizontalSpeedIncrease;
        }
        Vec3 direction = new Vec3(player.m_20154_().f_82479_, 0.0, player.m_20154_().f_82481_).m_82541_();
        double xMotion = currentMotion.f_82479_ + direction.f_82479_ * speedModifer;
        double zMotion = currentMotion.f_82481_ + direction.f_82481_ * speedModifer;
        double yMotion = currentMotion.f_82480_;
        double horizontalSpeedPercentage = 1.0 - Math.min(horizontalSpeed / (double)maxHorizontalSpeed, 1.0);
        if (!(yMotion < 0.0)) {
            return;
        }
        yMotion = (double)minFallSpeed + (currentMotion.f_82480_ - (double)minFallSpeed) * horizontalSpeedPercentage;
        player.m_20334_(xMotion, yMotion, zMotion);
        QuestHandler.progressQuest(player, Quest.FLIGHT, new Vec3(xMotion, 0.0, zMotion).m_82553_());
        PlayerPose newPose = this.jump.clone();
        double angle = 0.0;
        if (horizontalSpeedPercentage > 0.4 && currentMotion.f_82480_ < 0.0) {
            angle = Math.atan2(this.prevMotion.f_82481_, this.prevMotion.f_82479_) - Math.atan2(direction.f_82481_, direction.f_82479_);
        }
        if (angle > 0.2) {
            angle = 0.2;
        } else if (angle < -0.2) {
            angle = -0.2;
        }
        double xRot = 1.75 * (1.0 - horizontalSpeedPercentage) - 0.375;
        if (xRot < 0.0) {
            xRot = 0.0;
        } else if (xRot > 1.0) {
            xRot = 1.0;
        }
        newPose.addAngle("Body", new Vec3(Math.toRadians(90.0 * xRot), 0.0, Math.toRadians(180.0 * angle)), 11);
        PoseHandler.addPose((UUID)player.m_20148_(), (PlayerPose)newPose);
        this.prevMotion = direction;
    }

    @Override
    public void tickServer(TickEvent.PlayerTickEvent event) {
        Reflection.allowFlight((ServerPlayer)event.player);
        super.tickServer(event);
        this.tickInactiveServer(event);
        event.player.f_19789_ = 0.0f;
    }
}

