/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques.QiCondenserTechniques;

import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.ICultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.Damage.QiDamageSource;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.AttackTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.TechniqueStatModification;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;

public class ItemEnhanceTechnique
extends AttackTechnique {
    protected boolean attack = false;

    public ItemEnhanceTechnique() {
        this.removeTechniqueStat(DefaultTechniqueStatIDs.range);
        this.langLocation = "cultivationcraft.technique.itemenhance";
        this.Element = Elements.noElement;
        this.type = Technique.useType.Toggle;
        this.multiple = false;
        this.icon = new ResourceLocation("cultivationcraft", "textures/techniques/icons/itemenhance.png");
        this.canLevel = true;
        this.addMinTechniqueStat(DefaultTechniqueStatIDs.qiCost, 0.1);
        TechniqueStatModification qiCostModification = new TechniqueStatModification(DefaultTechniqueStatIDs.qiCost);
        TechniqueStatModification damageModification = new TechniqueStatModification(DefaultTechniqueStatIDs.damage);
        qiCostModification.addStatChange(DefaultTechniqueStatIDs.qiCost, -0.01);
        damageModification.addStatChange(DefaultTechniqueStatIDs.qiCost, 0.05);
        damageModification.addStatChange(DefaultTechniqueStatIDs.damage, 0.01);
        this.addTechniqueStat(DefaultTechniqueStatIDs.qiCost, 10.0, qiCostModification);
        this.addTechniqueStat(DefaultTechniqueStatIDs.damage, 1.0, damageModification);
    }

    @Override
    public boolean isValid(Player player) {
        ICultivatorStats stats = CultivatorStats.getCultivatorStats(player);
        return stats.getCultivationType() == 0;
    }

    @Override
    public void onPlayerAttack(AttackEntityEvent event) {
        this.attack = true;
    }

    @Override
    public boolean cancelAttack(LivingAttackEvent event) {
        if (!this.attack) {
            return false;
        }
        this.attack = false;
        Player attackingPlayer = (Player)event.getSource().m_7639_();
        if (!CultivatorStats.getCultivatorStats(attackingPlayer).getCultivation().consumeQi(attackingPlayer, this.getTechniqueStat(DefaultTechniqueStatIDs.qiCost, attackingPlayer))) {
            this.deactivate(attackingPlayer);
            return false;
        }
        QiDamageSource newSource = new QiDamageSource(event.getSource().m_19385_(), event.getSource().m_7639_(), this.getElement(), true);
        event.getEntity().m_6469_((DamageSource)newSource, event.getAmount() + (float)this.getTechniqueStat(DefaultTechniqueStatIDs.damage, attackingPlayer));
        this.levelUp(attackingPlayer, (float)this.getTechniqueStat(DefaultTechniqueStatIDs.damage, attackingPlayer));
        return true;
    }
}

