/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques.QiCondenserTechniques;

import DaoOfModding.Cultivationcraft.Client.Renderers.QiGlowRenderer;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.ICultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.Damage.QiDamageSource;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.TechniqueStatModification;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;

public class QiBarrierTechnique
extends Technique {
    public static final ResourceLocation qiToHealthRatio = new ResourceLocation("cultivationcraft", "cultivationcraft.tstat.qihealthratio");
    public static final ResourceLocation statusResist = new ResourceLocation("cultivationcraft", "cultivationcraft.tstat.statusresist");

    public QiBarrierTechnique() {
        this.langLocation = "cultivationcraft.technique.barrier";
        this.Element = Elements.noElement;
        this.type = Technique.useType.Toggle;
        this.multiple = false;
        this.icon = new ResourceLocation("cultivationcraft", "textures/techniques/icons/barrier.png");
        this.canLevel = true;
        this.addMinTechniqueStat(DefaultTechniqueStatIDs.qiCost, 0.1);
        this.addMaxTechniqueStat(statusResist, 1.0);
        TechniqueStatModification qiCostModification = new TechniqueStatModification(DefaultTechniqueStatIDs.qiCost);
        TechniqueStatModification qiToHealthModification = new TechniqueStatModification(qiToHealthRatio);
        TechniqueStatModification statusResistModification = new TechniqueStatModification(statusResist);
        qiCostModification.addStatChange(DefaultTechniqueStatIDs.qiCost, -5.0E-4);
        qiToHealthModification.addStatChange(DefaultTechniqueStatIDs.qiCost, 0.001);
        qiToHealthModification.addStatChange(qiToHealthRatio, 1.0E-4);
        statusResistModification.addStatChange(statusResist, 1.0E-4);
        statusResistModification.addStatChange(qiToHealthRatio, -1.0E-4);
        this.addTechniqueStat(DefaultTechniqueStatIDs.qiCost, 1.0, qiCostModification);
        this.addTechniqueStat(qiToHealthRatio, 0.1, qiToHealthModification);
        this.addTechniqueStat(statusResist, 0.0, statusResistModification);
    }

    @Override
    public boolean isValid(Player player) {
        ICultivatorStats stats = CultivatorStats.getCultivatorStats(player);
        return stats.getCultivationType() == 0;
    }

    @Override
    public void tickClient(TickEvent.PlayerTickEvent event) {
        if (!CultivatorStats.getCultivatorStats(event.player).getCultivation().consumeQi(event.player, this.getTechniqueStat(DefaultTechniqueStatIDs.qiCost, event.player) / 20.0)) {
            this.deactivate(event.player);
            return;
        }
        QiGlowRenderer.setQiVisible((Entity)event.player, Elements.getElement(this.getElement()));
        super.tickClient(event);
    }

    @Override
    public void tickServer(TickEvent.PlayerTickEvent event) {
        if (!CultivatorStats.getCultivatorStats(event.player).getCultivation().consumeQi(event.player, this.getTechniqueStat(DefaultTechniqueStatIDs.qiCost, event.player) / 20.0)) {
            this.deactivate(event.player);
            return;
        }
        super.tickServer(event);
    }

    @Override
    public float onDamage(QiDamageSource source, float amount, Player player) {
        if (CultivatorStats.getCultivatorStats(player).getCultivation().consumeQi(player, (double)amount / this.getTechniqueStat(qiToHealthRatio, player))) {
            this.levelUp(player, amount);
            Elements.getElement(source.getElement()).applyStatusEffect(source, (Entity)player, (float)((double)amount - this.getTechniqueStat(statusResist, player) * (double)amount));
            return 0.0f;
        }
        return amount;
    }
}

