/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques.QiCondenserTechniques;

import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.ICultivatorStats;
import DaoOfModding.Cultivationcraft.Common.PlayerUtils;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.QiProjectile;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.DefaultTechniqueStatIDs;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.TechniqueStatModification;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class QiEmission
extends Technique {
    public static final ResourceLocation amount = new ResourceLocation("cultivationcraft", "cultivationcraft.tstat.amount");

    public QiEmission() {
        this.langLocation = "cultivationcraft.technique.emission";
        this.Element = Elements.noElement;
        this.type = Technique.useType.Tap;
        this.multiple = false;
        this.icon = new ResourceLocation("cultivationcraft", "textures/techniques/icons/emission.png");
        this.canLevel = true;
        this.addMinTechniqueStat(DefaultTechniqueStatIDs.qiCost, 0.1);
        TechniqueStatModification qiCostModification = new TechniqueStatModification(DefaultTechniqueStatIDs.qiCost);
        TechniqueStatModification qiDamageModification = new TechniqueStatModification(DefaultTechniqueStatIDs.damage);
        TechniqueStatModification qiSpeedModification = new TechniqueStatModification(DefaultTechniqueStatIDs.movementSpeed);
        TechniqueStatModification lifetimeModification = new TechniqueStatModification(DefaultTechniqueStatIDs.lifetime);
        TechniqueStatModification amountModification = new TechniqueStatModification(amount);
        qiCostModification.addStatChange(DefaultTechniqueStatIDs.qiCost, -0.01);
        qiDamageModification.addStatChange(DefaultTechniqueStatIDs.damage, 0.01);
        qiDamageModification.addStatChange(DefaultTechniqueStatIDs.qiCost, 0.02);
        qiSpeedModification.addStatChange(DefaultTechniqueStatIDs.movementSpeed, 0.01);
        qiSpeedModification.addStatChange(DefaultTechniqueStatIDs.qiCost, 0.01);
        amountModification.addStatChange(amount, 0.005);
        amountModification.addStatChange(DefaultTechniqueStatIDs.qiCost, 0.01);
        lifetimeModification.addStatChange(DefaultTechniqueStatIDs.lifetime, 0.01);
        lifetimeModification.addStatChange(DefaultTechniqueStatIDs.qiCost, 0.01);
        this.addTechniqueStat(DefaultTechniqueStatIDs.qiCost, 10.0, qiCostModification);
        this.addTechniqueStat(DefaultTechniqueStatIDs.damage, 5.0, qiDamageModification);
        this.addTechniqueStat(DefaultTechniqueStatIDs.movementSpeed, 0.25, qiSpeedModification);
        this.addTechniqueStat(DefaultTechniqueStatIDs.lifetime, 1.0, lifetimeModification);
        this.addTechniqueStat(amount, 1.0, amountModification);
    }

    @Override
    public boolean isValid(Player player) {
        ICultivatorStats stats = CultivatorStats.getCultivatorStats(player);
        return stats.getCultivationType() == 0;
    }

    @Override
    public void activate(Player player) {
        super.activate(player);
        if (!player.f_19853_.f_46443_) {
            int number = (int)this.getTechniqueStat(amount, player);
            if (number == 1) {
                this.spawnProjectile(player, new Vec3(0.0, 0.0, 0.0));
            } else {
                this.spawnInCircle(player, number);
            }
        }
        this.deactivate(player);
    }

    protected void spawnInCircle(Player player, int number) {
        float angleInterval = 360.0f / (float)number;
        float distanceBetween = 0.5f + (float)(number / 10);
        for (int i = 0; i < number; ++i) {
            float x = (float)((double)distanceBetween * Math.cos(Math.toRadians(angleInterval * (float)i)));
            float y = (float)((double)distanceBetween * Math.sin(Math.toRadians(angleInterval * (float)i)));
            this.spawnProjectile(player, new Vec3((double)x, (double)y, 0.0).m_82524_((float)Math.toRadians(180.0f - player.m_6080_())));
        }
    }

    protected void spawnProjectile(Player player, Vec3 positionModifier) {
        if (!CultivatorStats.getCultivatorStats(player).getCultivation().consumeQi(player, this.getTechniqueStat(DefaultTechniqueStatIDs.qiCost, player))) {
            return;
        }
        Vec3 pos = PlayerUtils.getPosition((Entity)player).m_82549_(positionModifier);
        QiProjectile projectile = new QiProjectile(player.f_19853_, (LivingEntity)player, pos.f_82479_, pos.f_82480_, pos.f_82481_, this.Element, (int)this.getTechniqueStat(DefaultTechniqueStatIDs.damage, player), (float)this.getTechniqueStat(DefaultTechniqueStatIDs.movementSpeed, player), this, (float)this.getTechniqueStat(DefaultTechniqueStatIDs.lifetime, player));
        projectile.setDirection(player.m_20154_());
        player.f_19853_.m_7967_((Entity)projectile);
    }
}

