/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Common.Qi.Techniques;

import DaoOfModding.Cultivationcraft.Client.genericClientFunctions;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.Cultivation.CultivationType;
import DaoOfModding.Cultivationcraft.Common.Qi.Damage.QiDamageSource;
import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.PlayerStatModifications;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.TechniqueStats.TechniqueStatModification;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.ClientPacketHandler;
import DaoOfModding.mlmanimator.Client.Poses.PlayerPose;
import DaoOfModding.mlmanimator.Client.Poses.PoseHandler;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class Technique {
    protected useType type;
    protected ResourceLocation icon;
    protected ResourceLocation overlay;
    protected String langLocation = "cultivationcraft.technique.example";
    protected ResourceLocation Element;
    protected boolean active = false;
    protected boolean overlayOn = false;
    protected boolean multiple = true;
    protected int cooldown = 5;
    protected int cooldownCount = 0;
    protected int channelLength = 0;
    protected int currentChannel = 0;
    protected PlayerPose pose = new PlayerPose();
    protected ArrayList<AttributeModifier> modifiers = new ArrayList();
    protected ArrayList<MobEffect> effects = new ArrayList();
    protected PlayerStatModifications stats = new PlayerStatModifications();
    protected ResourceLocation progress = new ResourceLocation("cultivationcraft", "textures/gui/progressbar.png");
    public boolean toDeactivate = false;
    protected boolean elytraDisables = false;
    protected boolean legAnimationLockOff = false;
    protected int animationRecoveryTime = 20;
    protected int legAnimationCountdown = 0;
    protected boolean canBreathWhileActive = true;
    protected HashMap<ResourceLocation, Double> defaultStats = new HashMap();
    protected HashMap<ResourceLocation, TechniqueStatModification> statChangesPerLevel = new HashMap();
    protected HashMap<ResourceLocation, Double> minStats = new HashMap();
    protected HashMap<ResourceLocation, Double> maxStats = new HashMap();
    protected boolean canLevel = false;

    public Technique() {
        this.Element = Elements.noElement;
        this.type = useType.Toggle;
        this.icon = new ResourceLocation("cultivationcraft", "textures/techniques/icons/example.png");
    }

    protected void addTechniqueStat(ResourceLocation stat, double amount, TechniqueStatModification changePerLevel) {
        this.defaultStats.put(stat, amount);
        if (this.canLevel && changePerLevel != null) {
            this.statChangesPerLevel.put(stat, changePerLevel);
        }
    }

    protected void addMinTechniqueStat(ResourceLocation stat, double amount) {
        this.minStats.put(stat, amount);
    }

    protected void addMaxTechniqueStat(ResourceLocation stat, double amount) {
        this.maxStats.put(stat, amount);
    }

    protected void removeTechniqueStat(ResourceLocation stat) {
        this.defaultStats.remove(stat);
    }

    public TechniqueStatModification getStatChangesPerLevel(ResourceLocation stat) {
        return this.statChangesPerLevel.get(stat);
    }

    public void levelUp(Player player, double amount) {
        if (!this.canLevel || player.f_19853_.f_46443_) {
            return;
        }
        CultivatorStats.getCultivatorStats(player).getCultivation().levelTech(this, amount, player);
    }

    public boolean canLevel() {
        return this.canLevel;
    }

    public ResourceLocation getFirstStatChange() {
        return (ResourceLocation)this.statChangesPerLevel.keySet().toArray()[0];
    }

    protected void addTechniqueStat(ResourceLocation stat, double amount) {
        this.addTechniqueStat(stat, amount, null);
    }

    public String getTechniqueStatString(Player player) {
        Object statString = "";
        for (ResourceLocation stat : this.getTechniqueStats()) {
            statString = (String)statString + "\n" + Component.m_237115_((String)stat.m_135815_()).getString() + ": ";
            double value = this.getTechniqueStat(stat, player);
            if ((value = (double)((int)(value * 1000.0)) / 1000.0) % 1.0 == 0.0) {
                statString = (String)statString + (int)value;
                continue;
            }
            statString = (String)statString + value;
        }
        return statString;
    }

    public Set<ResourceLocation> getTechniqueStats() {
        return this.defaultStats.keySet();
    }

    public boolean hasTechniqueStat(ResourceLocation stat) {
        return this.defaultStats.containsKey(stat);
    }

    public double getTechniqueStat(ResourceLocation stat, Player player) {
        double max;
        double min;
        double defaultStat = this.getTechniqueDefaultStat(stat);
        CultivationType cultivation = CultivatorStats.getCultivatorStats(player).getCultivation();
        if (this.canLevel) {
            for (Map.Entry<ResourceLocation, TechniqueStatModification> modification : this.statChangesPerLevel.entrySet()) {
                if (modification.getValue() == null) continue;
                int statLevel = (int)cultivation.getStatLevel(this.getClass(), modification.getKey()).doubleValue();
                defaultStat += modification.getValue().getStatChange(stat) * (double)statLevel;
            }
        }
        if (this.minStats.containsKey(stat) && (min = this.minStats.get(stat).doubleValue()) > defaultStat) {
            return min;
        }
        if (this.maxStats.containsKey(stat) && (max = this.maxStats.get(stat).doubleValue()) < defaultStat) {
            return max;
        }
        return defaultStat;
    }

    public double getTechniqueDefaultStat(ResourceLocation stat) {
        return this.defaultStats.get(stat);
    }

    protected void setLegAnimationLockOffWhileActive(int ticksWhileDeactivated) {
        this.legAnimationLockOff = true;
        this.animationRecoveryTime = ticksWhileDeactivated;
    }

    public useType getType() {
        return this.type;
    }

    public boolean disableBreathing() {
        return !this.canBreathWhileActive;
    }

    public String getDescription() {
        return Component.m_237115_((String)(this.langLocation + ".description")).getString();
    }

    public PlayerStatModifications getStats() {
        return this.stats;
    }

    public boolean isValid(Player player) {
        return false;
    }

    public ResourceLocation getElement() {
        return this.Element;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public String getName() {
        return Component.m_237115_((String)this.langLocation).getString();
    }

    public boolean isCalled(String name) {
        return this.langLocation.compareTo(name) == 0;
    }

    public boolean allowMultiple() {
        return this.multiple;
    }

    public void useKeyPressed(boolean keyDown, Player player) {
        if (this.cooldownCount > 0) {
            return;
        }
        if (this.type == useType.Channel) {
            if (this.active && !keyDown) {
                this.onRelease(player);
            }
            if (!keyDown) {
                this.deactivate(player);
            } else if (keyDown && !this.active) {
                this.activate(player);
            }
        } else if (this.type == useType.Toggle) {
            if (!keyDown) {
                if (this.active) {
                    this.deactivate(player);
                } else {
                    this.activate(player);
                }
            }
        } else if (this.type == useType.Tap && keyDown) {
            this.activate(player);
        }
    }

    public void activate(Player player) {
        if (this.elytraDisables && player.m_6844_(EquipmentSlot.CHEST).m_41720_() == Items.f_42741_) {
            return;
        }
        this.active = true;
        this.addModifiers(player);
    }

    public void deactivate(Player player) {
        this.active = false;
        this.cooldownCount = this.cooldown;
        this.currentChannel = 0;
        this.toDeactivate = !player.f_19853_.f_46443_;
        this.removeModifiers(player);
    }

    protected void addModifiers(Player player) {
        if (this.modifiers.size() == 0 && this.effects.size() == 0) {
            return;
        }
        AttributeInstance modifierInstance = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        boolean modified = false;
        for (AttributeModifier modifier : this.modifiers) {
            if (modifierInstance.m_22109_(modifier)) continue;
            modifierInstance.m_22118_(modifier);
            modified = true;
        }
        for (MobEffect effect : this.effects) {
            if (player.m_21023_(effect)) continue;
            player.m_7292_(new MobEffectInstance(effect, 9999999, 0, false, false));
            modified = true;
        }
        if (modified) {
            BodyPartStatControl.updateStats(player);
        }
    }

    protected void removeModifiers(Player player) {
        if (this.modifiers.size() == 0 && this.effects.size() == 0) {
            return;
        }
        AttributeInstance modifierInstance = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        for (AttributeModifier modifier : this.modifiers) {
            modifierInstance.m_22130_(modifier);
        }
        for (MobEffect effect : this.effects) {
            if (!player.m_21023_(effect)) continue;
            player.m_21195_(effect);
        }
        BodyPartStatControl.updateStats(player);
    }

    public void onFall(LivingFallEvent event) {
    }

    protected void onRelease(Player player) {
    }

    protected void setOverlay(ResourceLocation location) {
        this.overlay = location;
        this.overlayOn = true;
    }

    public void writeBuffer(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.writeNBT());
    }

    public static Technique readBuffer(FriendlyByteBuf buffer) {
        CompoundTag nbt = buffer.m_130260_();
        return Technique.readNBT(nbt);
    }

    public void setCooldown(int ticks) {
        this.cooldownCount = ticks;
    }

    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        String className = this.getClass().getName();
        nbt.m_128359_("className", className);
        nbt.m_128379_("active", this.active);
        nbt.m_128405_("cooldown", this.cooldownCount);
        nbt.m_128379_("toDeactivate", this.toDeactivate);
        nbt.m_128405_("legAnimationCountdown", this.legAnimationCountdown);
        this.toDeactivate = false;
        return nbt;
    }

    public static Technique readNBT(CompoundTag nbt) {
        Technique newTech;
        String className = nbt.m_128461_("className");
        try {
            Class<?> test = Class.forName(className);
            newTech = (Technique)test.newInstance();
        }
        catch (Exception e) {
            Cultivationcraft.LOGGER.error(className + " not found when loading Technique");
            return null;
        }
        newTech.readNBTData(nbt);
        return newTech;
    }

    public void readNBTData(CompoundTag nbt) {
        this.setActive(nbt.m_128471_("active"));
        this.setCooldown(nbt.m_128451_("cooldown"));
        this.legAnimationCountdown = nbt.m_128451_("legAnimationCountdown");
        this.toDeactivate = nbt.m_128471_("toDeactivate");
    }

    public void readBufferData(FriendlyByteBuf buffer) {
        this.setActive(buffer.readBoolean());
    }

    public void onInput() {
    }

    public void tickServer(TickEvent.PlayerTickEvent event) {
        if (this.elytraDisables && event.player.m_6844_(EquipmentSlot.CHEST).m_41720_() == Items.f_42741_) {
            this.deactivate(event.player);
            return;
        }
        this.addModifiers(event.player);
        if (this.type == useType.Channel && this.currentChannel < this.channelLength) {
            ++this.currentChannel;
        }
    }

    public void tickClient(TickEvent.PlayerTickEvent event) {
        if (this.elytraDisables && event.player.m_6844_(EquipmentSlot.CHEST).m_41720_() == Items.f_42741_) {
            this.deactivate(event.player);
            return;
        }
        if (this.legAnimationLockOff) {
            PoseHandler.getPlayerPoseHandler((UUID)event.player.m_20148_()).lockLegPose(null);
            this.legAnimationCountdown = this.animationRecoveryTime;
        }
        this.addModifiers(event.player);
        if (this.type == useType.Channel && this.currentChannel < this.channelLength) {
            ++this.currentChannel;
        }
        PoseHandler.addPose((UUID)event.player.m_20148_(), (PlayerPose)this.pose);
    }

    public void tickInactiveClient(TickEvent.PlayerTickEvent event) {
        if (this.legAnimationLockOff && this.legAnimationCountdown > 0) {
            --this.legAnimationCountdown;
            PoseHandler.getPlayerPoseHandler((UUID)event.player.m_20148_()).lockLegPose(null);
        }
        if (this.toDeactivate) {
            this.deactivate(event.player);
        }
        if (this.cooldownCount > 0) {
            --this.cooldownCount;
        }
    }

    public void tickInactiveServer(TickEvent.PlayerTickEvent event) {
        if (this.cooldownCount > 0) {
            --this.cooldownCount;
        }
    }

    public int getCooldown() {
        return this.cooldownCount;
    }

    public float onDamage(QiDamageSource source, float amount, Player player) {
        return amount;
    }

    public void renderPlayerView() {
        if (this.active && this.type == useType.Channel && this.channelLength > 0) {
            int scaledWidth = Minecraft.m_91087_().m_91268_().m_85445_();
            int scaledHeight = Minecraft.m_91087_().m_91268_().m_85446_();
            float minPercent = 0.3f;
            float maxPercent = 0.675f;
            float percent = (float)this.currentChannel / (float)this.channelLength;
            float adjustedWidth = minPercent + (maxPercent - minPercent) * percent;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.progress);
            GlStateManager.m_84525_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_5483_(0.0, (double)scaledHeight, -90.0).m_7421_(0.0f, 0.5f).m_5752_();
            bufferbuilder.m_5483_((double)scaledWidth, (double)scaledHeight, -90.0).m_7421_(1.0f, 0.5f).m_5752_();
            bufferbuilder.m_5483_((double)scaledWidth, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
            bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
            tesselator.m_85914_();
            bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_5483_(0.0, (double)scaledHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
            bufferbuilder.m_5483_((double)(adjustedWidth * (float)scaledWidth), (double)scaledHeight, -90.0).m_7421_(1.0f * adjustedWidth, 1.0f).m_5752_();
            bufferbuilder.m_5483_((double)(adjustedWidth * (float)scaledWidth), 0.0, -90.0).m_7421_(1.0f * adjustedWidth, 0.5f).m_5752_();
            bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.5f).m_5752_();
            tesselator.m_85914_();
        }
    }

    public void render() {
    }

    public void renderOverlay() {
        if (!this.overlayOn) {
            return;
        }
        int scaledWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int scaledHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.overlay);
        GlStateManager.m_84525_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_(0.0, (double)scaledHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)scaledWidth, (double)scaledHeight, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)scaledWidth, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
    }

    public void sendInfo(int info) {
        ClientPacketHandler.sendTechniqueInfoToServer(genericClientFunctions.getPlayer().m_20148_(), info, this.langLocation);
    }

    public void processInfo(Player player, int info) {
    }

    public static enum useType {
        Toggle,
        Channel,
        Tap;

    }
}

