/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.IBodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.ChunkQiSources.ChunkQiSources;
import DaoOfModding.Cultivationcraft.Common.Capabilities.ChunkQiSources.IChunkQiSources;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.ICultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.CultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.ICultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Qi.Effects.WindInstance;
import DaoOfModding.Cultivationcraft.Network.Packets.AttackPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.BloodPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.BodyForgeSelectionPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.BodyModificationsPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.BreakthroughPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.ChunkQiSourcesPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.ConvertToFlyingPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.CultivatorStats.CultivatorStatsPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.CultivatorStats.CultivatorTypePacket;
import DaoOfModding.Cultivationcraft.Network.Packets.CultivatorStats.TechniqueStatSelectionPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.CultivatorTechniquesPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.ElementalEffectPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.ExternalBloodTickPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.PartInfoPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.QuestCancelPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.QuestPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.StaminaUsePacket;
import DaoOfModding.Cultivationcraft.Network.Packets.TechniqueInfoPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.TechniqueUsePacket;
import DaoOfModding.Cultivationcraft.Network.Packets.WindPacket;
import DaoOfModding.Cultivationcraft.Network.Packets.keypressPacket;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PacketHandler {
    protected static final byte KEYPRESS = 3;
    protected static final byte STAMINA_USE = 5;
    protected static final byte ATTACK = 7;
    protected static final byte LevelChunk_QI_SOURCES = 10;
    protected static final byte ELEMENTAL_EFFECT = 12;
    protected static final byte TECHNIQUE_USE = 20;
    protected static final byte TECHNIQUE_INFO = 21;
    protected static final byte PART_INFO = 22;
    protected static final byte QUEST_PROGRESS = 30;
    protected static final byte QUEST_CANCEL = 31;
    protected static final byte FLYING_SWORD_NBT_ID = 35;
    protected static final byte WIND_INSTANCE = 43;
    protected static final byte BLOOD_SPAWN_ID = 55;
    protected static final byte EXTERNAL_BLOOD_TICK_ID = 56;
    protected static final byte CULTIVATION_BREAKTHROUGH = 90;
    protected static final byte CULTIVATOR_TECH_STAT = 94;
    protected static final byte CULTIVATOR_TYPE = 95;
    protected static final byte BODY_FORGE_SELECTION = 96;
    protected static final byte BODY_MODIFICATIONS = 97;
    protected static final byte CULTIVATOR_TECHNIQUES = 98;
    protected static final byte CULTIVATOR_STATS = 99;
    protected static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("cultivationcraft", "main"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        channel.registerMessage(3, keypressPacket.class, keypressPacket::encode, keypressPacket::decode, keypressPacket::handle);
        channel.registerMessage(7, AttackPacket.class, AttackPacket::encode, AttackPacket::decode, AttackPacket::handle);
        channel.registerMessage(5, StaminaUsePacket.class, StaminaUsePacket::encode, StaminaUsePacket::decode, StaminaUsePacket::handle);
        channel.registerMessage(10, ChunkQiSourcesPacket.class, ChunkQiSourcesPacket::encode, ChunkQiSourcesPacket::decode, ChunkQiSourcesPacket::handle);
        channel.registerMessage(12, ElementalEffectPacket.class, ElementalEffectPacket::encode, ElementalEffectPacket::decode, ElementalEffectPacket::handle);
        channel.registerMessage(20, TechniqueUsePacket.class, TechniqueUsePacket::encode, TechniqueUsePacket::decode, TechniqueUsePacket::handle);
        channel.registerMessage(21, TechniqueInfoPacket.class, TechniqueInfoPacket::encode, TechniqueInfoPacket::decode, TechniqueInfoPacket::handle);
        channel.registerMessage(22, PartInfoPacket.class, PartInfoPacket::encode, PartInfoPacket::decode, PartInfoPacket::handle);
        channel.registerMessage(30, QuestPacket.class, QuestPacket::encode, QuestPacket::decode, QuestPacket::handle);
        channel.registerMessage(31, QuestCancelPacket.class, QuestCancelPacket::encode, QuestCancelPacket::decode, QuestCancelPacket::handle);
        channel.registerMessage(35, ConvertToFlyingPacket.class, ConvertToFlyingPacket::encode, ConvertToFlyingPacket::decode, ConvertToFlyingPacket::handle);
        channel.registerMessage(43, WindPacket.class, WindPacket::encode, WindPacket::decode, WindPacket::handle);
        channel.registerMessage(55, BloodPacket.class, BloodPacket::encode, BloodPacket::decode, BloodPacket::handle);
        channel.registerMessage(56, ExternalBloodTickPacket.class, ExternalBloodTickPacket::encode, ExternalBloodTickPacket::decode, ExternalBloodTickPacket::handle);
        channel.registerMessage(90, BreakthroughPacket.class, BreakthroughPacket::encode, BreakthroughPacket::decode, BreakthroughPacket::handle);
        channel.registerMessage(98, CultivatorTechniquesPacket.class, CultivatorTechniquesPacket::encode, CultivatorTechniquesPacket::decode, CultivatorTechniquesPacket::handle);
        channel.registerMessage(99, CultivatorStatsPacket.class, CultivatorStatsPacket::encode, CultivatorStatsPacket::decode, CultivatorStatsPacket::handle);
        channel.registerMessage(95, CultivatorTypePacket.class, CultivatorTypePacket::encode, CultivatorTypePacket::decode, CultivatorTypePacket::handle);
        channel.registerMessage(96, BodyForgeSelectionPacket.class, BodyForgeSelectionPacket::encode, BodyForgeSelectionPacket::decode, BodyForgeSelectionPacket::handle);
        channel.registerMessage(97, BodyModificationsPacket.class, BodyModificationsPacket::encode, BodyModificationsPacket::decode, BodyModificationsPacket::handle);
        channel.registerMessage(94, TechniqueStatSelectionPacket.class, TechniqueStatSelectionPacket::encode, TechniqueStatSelectionPacket::decode, TechniqueStatSelectionPacket::handle);
    }

    public static void sendAttackToClient(UUID playerID, HitResult.Type type, Vec3 pos, UUID targetID, Direction direction, int slot) {
        AttackPacket pack = new AttackPacket(playerID, type, pos, targetID, direction, slot);
        channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerID)), (Object)pack);
    }

    public static void sendBloodSpawnToClient(UUID playerID, Vec3 source, double amount) {
        BloodPacket pack = new BloodPacket(playerID, amount, source);
        channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerID)), (Object)pack);
    }

    public static void sendQuestProgressToClient(UUID player, double amount) {
        QuestPacket packet = new QuestPacket(player, amount);
        channel.send(PacketDistributor.PLAYER.with(() -> ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(player)), (Object)packet);
    }

    public static void sendChunkQiSourcesToClient(LevelChunk LevelChunk2) {
        IChunkQiSources sources = ChunkQiSources.getChunkQiSources(LevelChunk2);
        ChunkQiSourcesPacket pack = new ChunkQiSourcesPacket(sources);
        channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> LevelChunk2), (Object)pack);
    }

    public static void sendWindInstanceToClients(WindInstance wind, Entity entity) {
        WindPacket pack = new WindPacket(wind, entity.m_20148_());
        channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)pack);
    }

    public static void sendChunkQiSourcesToClient(LevelChunk LevelChunk2, ServerPlayer player) {
        IChunkQiSources sources = ChunkQiSources.getChunkQiSources(LevelChunk2);
        ChunkQiSourcesPacket pack = new ChunkQiSourcesPacket(sources);
        channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)pack);
    }

    public static void sendCultivatorStatsToClient(Player player) {
        PacketDistributor.PacketTarget target = PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player);
        PacketHandler.sendCultivatorStatsToClient(player, target);
        PacketHandler.sendCultivatorTechniquesToClient(player);
    }

    public static void sendCultivatorStatsToSpecificClient(Player player, ServerPlayer toSend) {
        PacketDistributor.PacketTarget target = PacketDistributor.PLAYER.with(() -> toSend);
        PacketHandler.sendCultivatorStatsToClient(player, target);
        PacketHandler.sendCultivatorTechniquesToSpecificClient(player, toSend);
    }

    protected static void sendCultivatorStatsToClient(Player player, PacketDistributor.PacketTarget distribute) {
        ICultivatorStats stats = CultivatorStats.getCultivatorStats(player);
        CultivatorStatsPacket pack = new CultivatorStatsPacket(player.m_20148_(), stats);
        channel.send(distribute, (Object)pack);
    }

    public static void updateStaminaForClients(float stamina, Player player) {
        PacketDistributor.PacketTarget target = PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player);
        StaminaUsePacket pack = new StaminaUsePacket(stamina, player.m_20148_());
        channel.send(target, (Object)pack);
    }

    public static void sendBodyModificationsToSpecificClient(Player player, ServerPlayer toSend) {
        PacketDistributor.PacketTarget target = PacketDistributor.PLAYER.with(() -> toSend);
        PacketHandler.sendBodyModificationsToClient(player, target);
    }

    public static void sendBodyModificationsToClient(Player player) {
        PacketDistributor.PacketTarget target = PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player);
        PacketHandler.sendBodyModificationsToClient(player, target);
    }

    protected static void sendBodyModificationsToClient(Player player, PacketDistributor.PacketTarget distribute) {
        IBodyModifications modifications = BodyModifications.getBodyModifications(player);
        BodyModificationsPacket pack = new BodyModificationsPacket(player.m_20148_(), modifications);
        channel.send(distribute, (Object)pack);
    }

    public static void sendTechniqueInfoToClients(TechniqueInfoPacket packet, Player except) {
        channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> except), (Object)packet);
    }

    public static void sendPartInfoToClients(PartInfoPacket packet, Player except) {
        channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> except), (Object)packet);
    }

    public static void sendCultivatorTechniquesToClient(Player player) {
        ICultivatorTechniques techs = CultivatorTechniques.getCultivatorTechniques(player);
        CultivatorTechniquesPacket pack = new CultivatorTechniquesPacket(player.m_20148_(), techs);
        channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)pack);
    }

    public static void sendCultivatorTechniquesToSpecificClient(Player player, ServerPlayer toSend) {
        ICultivatorTechniques techs = CultivatorTechniques.getCultivatorTechniques(player);
        CultivatorTechniquesPacket pack = new CultivatorTechniquesPacket(player.m_20148_(), techs);
        channel.send(PacketDistributor.PLAYER.with(() -> toSend), (Object)pack);
    }
}

