/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Client.genericClientFunctions;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.CultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.AttackTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class AttackPacket
extends Packet {
    protected UUID player = null;
    protected HitResult.Type targetType = HitResult.Type.MISS;
    protected Vec3 targetPos = null;
    protected UUID target = null;
    protected int techSlot = 0;
    protected Direction direction = Direction.UP;

    public AttackPacket(UUID playerID, HitResult.Type type, Vec3 pos, UUID targetUUID, Direction dir, int slot) {
        this.player = playerID;
        this.targetType = type;
        this.targetPos = pos;
        this.target = targetUUID;
        this.techSlot = slot;
        if (dir != null) {
            this.direction = dir;
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        if (this.player != null) {
            buffer.m_130077_(this.player);
            buffer.m_130068_((Enum)this.targetType);
            buffer.writeInt(this.techSlot);
            if (this.targetPos != null) {
                buffer.writeDouble(this.targetPos.f_82479_);
                buffer.writeDouble(this.targetPos.f_82480_);
                buffer.writeDouble(this.targetPos.f_82481_);
                buffer.m_130068_((Enum)this.direction);
                if (this.targetType == HitResult.Type.ENTITY) {
                    buffer.m_130077_(this.target);
                }
            }
        }
    }

    public static AttackPacket decode(FriendlyByteBuf buffer) {
        AttackPacket returnValue = new AttackPacket(null, HitResult.Type.MISS, null, null, Direction.UP, 0);
        try {
            UUID readingPlayer = buffer.m_130259_();
            HitResult.Type readingType = (HitResult.Type)buffer.m_130066_(HitResult.Type.class);
            int slot = buffer.readInt();
            Vec3 readingPos = null;
            UUID readingTargetID = null;
            Direction readingDir = null;
            if (readingType != HitResult.Type.MISS) {
                readingPos = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
                readingDir = (Direction)buffer.m_130066_(Direction.class);
                if (readingType == HitResult.Type.ENTITY) {
                    readingTargetID = buffer.m_130259_();
                }
            }
            return new AttackPacket(readingPlayer, readingType, readingPos, readingTargetID, readingDir, slot);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading Attack message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isServer()) {
            if (ctx.getSender().m_20148_().compareTo(this.player) != 0) {
                Cultivationcraft.LOGGER.warn("Client sent attack message for other player");
            } else {
                ctx.enqueueWork(() -> this.processServerPacket());
            }
        } else {
            ctx.enqueueWork(() -> this.processClientPacket());
        }
    }

    protected void processServerPacket() {
        ServerPlayer ownerEntity = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.player);
        if (ownerEntity == null) {
            return;
        }
        Technique tech = CultivatorTechniques.getCultivatorTechniques((Player)ownerEntity).getTechnique(this.techSlot);
        if (!(tech instanceof AttackTechnique)) {
            return;
        }
        PacketHandler.sendAttackToClient(this.player, this.targetType, this.targetPos, this.target, this.direction, this.techSlot);
        if (this.targetType == HitResult.Type.ENTITY) {
            double range = ((AttackTechnique)tech).getRange((Player)ownerEntity);
            AABB scan = new AABB(this.targetPos.f_82479_ - range * 2.0, this.targetPos.f_82480_ - range * 2.0, this.targetPos.f_82481_ - range * 2.0, this.targetPos.f_82479_ + range * 2.0, this.targetPos.f_82480_ + range * 2.0, this.targetPos.f_82481_ + range * 2.0);
            List entities = ownerEntity.m_20193_().m_45976_(Entity.class, scan);
            if (!entities.isEmpty()) {
                for (Entity testEntity : entities) {
                    if (!testEntity.m_20148_().equals(this.target)) continue;
                    ((AttackTechnique)tech).attackEntity((Player)ownerEntity, testEntity);
                    return;
                }
            }
        } else if (this.targetType == HitResult.Type.BLOCK) {
            BlockPos pos = new BlockPos((int)this.targetPos.f_82479_, (int)this.targetPos.f_82480_, (int)this.targetPos.f_82481_);
            BlockState block = ownerEntity.m_20193_().m_8055_(pos);
            if (block != null) {
                ((AttackTechnique)tech).attackBlock((Player)ownerEntity, block, pos, this.direction);
            }
        } else {
            ((AttackTechnique)tech).attackNothing((Player)ownerEntity);
        }
    }

    protected void processClientPacket() {
        double range;
        AABB scan;
        List entities;
        if (this.player.compareTo(genericClientFunctions.getPlayer().m_20148_()) == 0) {
            return;
        }
        Player pEntity = Minecraft.m_91087_().f_91073_.m_46003_(this.player);
        if (pEntity == null) {
            return;
        }
        Technique tech = CultivatorTechniques.getCultivatorTechniques(pEntity).getTechnique(this.techSlot);
        if (!(tech instanceof AttackTechnique)) {
            return;
        }
        Entity target = null;
        if (this.targetType == HitResult.Type.ENTITY && !(entities = pEntity.f_19853_.m_45976_(Entity.class, scan = new AABB(this.targetPos.f_82479_ - (range = ((AttackTechnique)tech).getRange(pEntity)) * 2.0, this.targetPos.f_82480_ - range * 2.0, this.targetPos.f_82481_ - range * 2.0, this.targetPos.f_82479_ + range * 2.0, this.targetPos.f_82480_ + range * 2.0, this.targetPos.f_82481_ + range * 2.0))).isEmpty()) {
            for (Entity testEntity : entities) {
                if (!testEntity.m_20148_().equals(target)) continue;
                target = testEntity;
                break;
            }
        }
        ((AttackTechnique)tech).attackAnimation(pEntity, target);
    }
}

