/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Client.Renderers.BloodRenderer;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class BloodPacket
extends Packet {
    protected UUID player;
    Vec3 source;
    double amount;

    public BloodPacket(UUID playerID, double damage, Vec3 sourcePosition) {
        this.player = playerID;
        this.amount = damage;
        this.source = sourcePosition;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        if (this.player != null) {
            buffer.m_130077_(this.player);
            buffer.writeDouble(this.amount);
            if (this.source != null) {
                buffer.writeBoolean(true);
                buffer.writeDouble(this.source.f_82479_);
                buffer.writeDouble(this.source.f_82480_);
                buffer.writeDouble(this.source.f_82481_);
            } else {
                buffer.writeBoolean(false);
            }
        }
    }

    public static BloodPacket decode(FriendlyByteBuf buffer) {
        BloodPacket returnValue = new BloodPacket(null, 0.0, null);
        try {
            UUID readingPlayer = buffer.m_130259_();
            double damage = buffer.readDouble();
            Vec3 sourcePosition = null;
            if (buffer.readBoolean()) {
                sourcePosition = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
            return new BloodPacket(readingPlayer, damage, sourcePosition);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading Blood spawn message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isServer()) {
            Cultivationcraft.LOGGER.warn("Client sent blood spawn message");
        } else {
            ctx.enqueueWork(() -> this.processClientPacket());
        }
    }

    protected void processClientPacket() {
        BloodRenderer.spawnBlood(Minecraft.m_91087_().f_91073_.m_46003_(this.player), this.source, this.amount);
    }
}

