/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.IBodyModifications;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPart;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartNames;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class BodyForgeSelectionPacket
extends Packet {
    protected String selectionID;

    public BodyForgeSelectionPacket(String ID) {
        this.selectionID = ID;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.selectionID);
    }

    public static BodyForgeSelectionPacket decode(FriendlyByteBuf buffer) {
        BodyForgeSelectionPacket returnValue = new BodyForgeSelectionPacket("");
        try {
            String readingID = buffer.m_130277_();
            return new BodyForgeSelectionPacket(readingID);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading BodyForgeSelection message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (!sideReceived.isClient()) {
            ctx.enqueueWork(() -> this.processPacket((Player)ctx.getSender()));
        } else {
            Cultivationcraft.LOGGER.warn("BodyForgeSelection Packet was received by client, THIS SHOULD NOT HAPPEN: " + this.toString());
        }
    }

    protected void processPacket(Player player) {
        IBodyModifications modifications = BodyModifications.getBodyModifications(player);
        if (modifications.getSelection().compareTo(this.selectionID) == 0) {
            return;
        }
        modifications.setProgress(0);
        if (this.selectionID.compareTo("") != 0) {
            BodyPart part = BodyPartNames.getPart(this.selectionID);
            if (part == null) {
                part = BodyPartNames.getOption(this.selectionID);
            }
            if (part == null || !part.canBeForged(player)) {
                Cultivationcraft.LOGGER.warn(player.m_7755_().getString() + " tried to forge an invalid bodyPart: " + this.selectionID);
                return;
            }
        }
        modifications.setSelection(this.selectionID);
        BodyPartStatControl.updateStats(player);
        PacketHandler.sendBodyModificationsToClient(player);
    }
}

