/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.IBodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.CultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class BodyModificationsPacket
extends Packet {
    protected UUID owner;
    protected IBodyModifications mods;

    public BodyModificationsPacket(UUID ownerID, IBodyModifications modifications) {
        this.owner = ownerID;
        this.mods = modifications;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.owner);
        buffer.m_130079_(this.mods.write());
    }

    public static BodyModificationsPacket decode(FriendlyByteBuf buffer) {
        BodyModificationsPacket returnValue = new BodyModificationsPacket(null, null);
        try {
            UUID readingOwner = buffer.m_130259_();
            BodyModifications modifications = new BodyModifications();
            modifications.read(buffer.m_130260_());
            return new BodyModificationsPacket(readingOwner, modifications);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading BodyModifications message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (this.owner == null) {
            Cultivationcraft.LOGGER.warn("BodyModifications Packet was invalid: " + this.toString());
            return;
        }
        if (sideReceived.isClient()) {
            ctx.enqueueWork(() -> this.processPacket());
        } else {
            Cultivationcraft.LOGGER.warn("BodyModifications Packet was received by server, THIS SHOULD NOT HAPPEN: " + this.toString());
        }
    }

    protected void processPacket() {
        Player player = Minecraft.m_91087_().f_91073_.m_46003_(this.owner);
        IBodyModifications modifications = BodyModifications.getBodyModifications(player);
        modifications.copy(this.mods);
        CultivatorTechniques.getCultivatorTechniques(player).determinePassives(player);
        BodyPartStatControl.updateStats(player);
    }
}

