/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.Cultivation.CultivationType;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class BreakthroughPacket
extends Packet {
    protected boolean downgrade = false;
    protected String cultivationString = "";

    public BreakthroughPacket(boolean down, String cult) {
        this.downgrade = down;
        this.cultivationString = cult;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.downgrade);
        buffer.m_130070_(this.cultivationString);
    }

    public static BreakthroughPacket decode(FriendlyByteBuf buffer) {
        try {
            Boolean down = buffer.readBoolean();
            String cult = buffer.m_130277_();
            return new BreakthroughPacket(down, cult);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading Breakthrough message: " + e);
            return new BreakthroughPacket(false, "");
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isServer()) {
            ctx.enqueueWork(() -> this.processPacket(ctx.getSender()));
        } else {
            Cultivationcraft.LOGGER.warn("Server sent Breakthrough packet message");
        }
    }

    protected void processPacket(ServerPlayer player) {
        CultivationType cultivation = CultivatorStats.getCultivatorStats((Player)player).getCultivation();
        if (this.downgrade) {
            cultivation.reset((Player)player);
            PacketHandler.sendCultivatorStatsToClient((Player)player);
        } else if (cultivation.canBreakthrough((Player)player)) {
            if (this.cultivationString.length() > 0 && cultivation.hasTribulated()) {
                cultivation.advance((Player)player, this.cultivationString);
            }
            if (cultivation.hasTribulation((Player)player)) {
                cultivation.startTribulation();
            } else {
                cultivation.breakthrough((Player)player);
            }
            PacketHandler.sendCultivatorStatsToClient((Player)player);
        }
    }
}

