/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Client.AddChunkQiSourceToClient;
import DaoOfModding.Cultivationcraft.Common.Capabilities.ChunkQiSources.ChunkQiSources;
import DaoOfModding.Cultivationcraft.Common.Capabilities.ChunkQiSources.IChunkQiSources;
import DaoOfModding.Cultivationcraft.Common.CommonListeners;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ChunkQiSourcesPacket
extends Packet {
    IChunkQiSources chunkQiSources;

    public ChunkQiSourcesPacket(IChunkQiSources sources) {
        this.chunkQiSources = sources;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.chunkQiSources.writeNBT());
    }

    public static ChunkQiSourcesPacket decode(FriendlyByteBuf buffer) {
        ChunkQiSourcesPacket returnValue = new ChunkQiSourcesPacket(null);
        try {
            ChunkQiSources testSource = new ChunkQiSources();
            testSource.readNBT(buffer.m_130260_());
            return new ChunkQiSourcesPacket(testSource);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading ChunkQiSource message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isServer()) {
            Cultivationcraft.LOGGER.warn("ChunkQiSourcePacket was received by server - This should not happen");
            return;
        }
        ctx.enqueueWork(() -> this.setToProcess());
    }

    protected void setToProcess() {
        AddChunkQiSourceToClient.addPacket(this);
    }

    public boolean processPacket() {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return true;
        }
        if (Minecraft.m_91087_().f_91073_.m_46472_().m_135782_().compareTo(this.chunkQiSources.getDimension()) != 0) {
            return true;
        }
        if (!Minecraft.m_91087_().f_91073_.m_7726_().m_5563_(this.chunkQiSources.getChunkPos().f_45578_, this.chunkQiSources.getChunkPos().f_45579_)) {
            return false;
        }
        LevelChunk LevelChunk2 = Minecraft.m_91087_().f_91073_.m_6325_(this.chunkQiSources.getChunkPos().f_45578_, this.chunkQiSources.getChunkPos().f_45579_);
        IChunkQiSources sources = ChunkQiSources.getChunkQiSources(LevelChunk2);
        sources.readNBT(this.chunkQiSources.writeNBT());
        CommonListeners.checkQiSourceIsTicking(sources);
        return true;
    }
}

