/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Common.FlyingSwordController;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ConvertToFlyingPacket
extends Packet {
    int heldItem;
    Player owner;

    public ConvertToFlyingPacket(int heldItemID) {
        this.heldItem = heldItemID;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        if (this.heldItem > -1) {
            buffer.writeInt(this.heldItem);
        }
    }

    public static ConvertToFlyingPacket decode(FriendlyByteBuf buffer) {
        ConvertToFlyingPacket returnValue = new ConvertToFlyingPacket(-1);
        try {
            int readingHeld = buffer.readInt();
            return new ConvertToFlyingPacket(readingHeld);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading ConvertToFlying message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Cultivationcraft.LOGGER.warn("ConvertToFlyingPacket was received by client - This should not happen");
            return;
        }
        if (this.heldItem == -1) {
            Cultivationcraft.LOGGER.warn("ConvertToFlyingPacket was invalid: " + this.toString());
            return;
        }
        this.owner = ctx.getSender();
        ctx.enqueueWork(() -> this.processPacket());
    }

    protected void processPacket() {
        FlyingSwordController.addFlyingItem(this.owner.m_150109_().m_8020_(this.heldItem), this.owner.m_20148_());
    }
}

