/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets.CultivatorStats;

import DaoOfModding.Cultivationcraft.Client.GUI.HelpItems;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.ICultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.PlayerHealthManager;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class CultivatorStatsPacket
extends Packet {
    protected UUID owner;
    protected ICultivatorStats cultStats;

    public CultivatorStatsPacket(UUID ownerID, ICultivatorStats stats) {
        this.owner = ownerID;
        this.cultStats = stats;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        if (this.owner != null) {
            buffer.m_130077_(this.owner);
            buffer.m_130079_(this.cultStats.writeNBT());
        }
    }

    public static CultivatorStatsPacket decode(FriendlyByteBuf buffer) {
        CultivatorStatsPacket returnValue = new CultivatorStatsPacket(null, null);
        try {
            UUID readingOwner = buffer.m_130259_();
            CultivatorStats stats = new CultivatorStats();
            stats.readNBT(buffer.m_130260_());
            return new CultivatorStatsPacket(readingOwner, stats);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading CultivatorStats message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (this.owner == null) {
            Cultivationcraft.LOGGER.warn("CultivatorStatsPacket was invalid: " + this.toString());
            return;
        }
        if (sideReceived.isClient()) {
            ctx.enqueueWork(() -> this.processPacket());
        } else {
            Cultivationcraft.LOGGER.warn("CultivatorStatsPacket was received by server, THIS SHOULD NOT HAPPEN: " + this.toString());
        }
    }

    protected void processPacket() {
        Player player = Minecraft.m_91087_().f_91073_.m_46003_(this.owner);
        CultivatorStats.getCultivatorStats(player).readNBT(this.cultStats.writeNBT());
        PlayerHealthManager.updateFoodStats(player);
        HelpItems.updateText();
    }
}

