/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets.CultivatorStats;

import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.PlayerHealthManager;
import DaoOfModding.Cultivationcraft.Common.Qi.Cultivation.FoundationEstablishmentCultivation;
import DaoOfModding.Cultivationcraft.Common.Qi.Cultivation.NoCultivation;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CultivatorTypePacket
extends Packet {
    protected UUID player;
    protected int cultivationType;

    public CultivatorTypePacket(UUID playerID, int type) {
        this.player = playerID;
        this.cultivationType = type;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        if (this.player != null) {
            buffer.m_130077_(this.player);
            buffer.writeInt(this.cultivationType);
        }
    }

    public static CultivatorTypePacket decode(FriendlyByteBuf buffer) {
        CultivatorTypePacket returnValue = new CultivatorTypePacket(null, -1);
        try {
            UUID readingPlayer = buffer.m_130259_();
            int type = buffer.readInt();
            return new CultivatorTypePacket(readingPlayer, type);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading CultivatorTypePacket message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isServer()) {
            if (ctx.getSender().m_20148_().compareTo(this.player) != 0) {
                Cultivationcraft.LOGGER.warn("Client sent target message for other player");
            } else {
                ctx.enqueueWork(() -> this.processServerPacket());
            }
        }
    }

    protected void processServerPacket() {
        ServerPlayer ownerEntity = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.player);
        if (CultivatorStats.getCultivatorStats((Player)ownerEntity).getCultivationType() != -1) {
            Cultivationcraft.LOGGER.warn("Tried to change player cultivation when cultivation type already selected");
            return;
        }
        CultivatorStats.getCultivatorStats((Player)ownerEntity).setCultivationType(this.cultivationType);
        if (this.cultivationType == 0) {
            FoundationEstablishmentCultivation newCultivation = new FoundationEstablishmentCultivation(1);
            newCultivation.setPreviousCultivation(new NoCultivation());
            CultivatorStats.getCultivatorStats((Player)ownerEntity).setCultivation(newCultivation);
            PlayerHealthManager.updateFoodStats((Player)ownerEntity);
        }
        PacketHandler.sendCultivatorStatsToClient((Player)ownerEntity);
    }
}

