/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets.CultivatorStats;

import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class TechniqueStatSelectionPacket
extends Packet {
    protected ResourceLocation selectedStat;
    protected String selectedTech;

    public TechniqueStatSelectionPacket(String tech, ResourceLocation selection) {
        this.selectedTech = tech;
        this.selectedStat = selection;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.selectedTech);
        buffer.m_130070_(this.selectedStat.toString());
    }

    public static TechniqueStatSelectionPacket decode(FriendlyByteBuf buffer) {
        TechniqueStatSelectionPacket returnValue = new TechniqueStatSelectionPacket("", null);
        try {
            return new TechniqueStatSelectionPacket(buffer.m_130277_(), new ResourceLocation(buffer.m_130277_()));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading TechniqueStatSelectionPacket message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isServer()) {
            ctx.enqueueWork(() -> this.processServerPacket((Player)ctx.getSender()));
        }
    }

    protected void processServerPacket(Player player) {
        CultivatorStats.getCultivatorStats(player).setTechniqueFocus(this.selectedTech, this.selectedStat);
        PacketHandler.sendCultivatorStatsToClient(player);
    }
}

