/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.CultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.ICultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class CultivatorTechniquesPacket
extends Packet {
    UUID owner;
    Technique[] techniques = new Technique[9];

    public CultivatorTechniquesPacket(UUID player, ICultivatorTechniques techs) {
        this.owner = player;
        if (techs != null) {
            for (int i = 0; i < 9; ++i) {
                this.techniques[i] = techs.getTechnique(i);
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.owner);
        for (int i = 0; i < 9; ++i) {
            if (this.techniques[i] != null) {
                buffer.writeBoolean(true);
                this.techniques[i].writeBuffer(buffer);
                continue;
            }
            buffer.writeBoolean(false);
        }
    }

    public static CultivatorTechniquesPacket decode(FriendlyByteBuf buffer) {
        CultivatorTechniquesPacket returnValue = new CultivatorTechniquesPacket(null, null);
        try {
            CultivatorTechniques techs = new CultivatorTechniques();
            UUID owner = buffer.m_130259_();
            for (int i = 0; i < 9; ++i) {
                if (buffer.readBoolean()) {
                    techs.setTechnique(i, Technique.readBuffer(buffer));
                    continue;
                }
                techs.setTechnique(i, null);
            }
            return new CultivatorTechniquesPacket(owner, techs);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading CultivatorTechniques message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (this.owner == null) {
            Cultivationcraft.LOGGER.warn("CultivatorTechniquesPacket was invalid: " + this.toString());
            return;
        }
        if (sideReceived.isClient()) {
            ctx.enqueueWork(() -> this.processPacket());
        } else {
            if (this.owner.compareTo(ctx.getSender().m_20148_()) != 0) {
                Cultivationcraft.LOGGER.warn("Client sent CultivatorTechniquesPacket for a different player: " + this.toString());
                return;
            }
            ctx.enqueueWork(() -> this.processPacketServer((Player)ctx.getSender()));
        }
    }

    protected void processPacket() {
        ICultivatorTechniques techs = CultivatorTechniques.getCultivatorTechniques(Minecraft.m_91087_().f_91073_.m_46003_(this.owner));
        for (int i = 0; i < 9; ++i) {
            techs.setTechnique(i, this.techniques[i]);
        }
    }

    protected void processPacketServer(Player player) {
        int i;
        ICultivatorTechniques techs = CultivatorTechniques.getCultivatorTechniques(player);
        for (i = 0; i < 9; ++i) {
            techs.setTechnique(i, null);
        }
        for (i = 0; i < 9; ++i) {
            if (this.techniques[i] == null || this.techniques[i].isValid(player) && (this.techniques[i].allowMultiple() || !techs.techniqueExists(this.techniques[i]))) {
                if (techs.getTechnique(i) != null && techs.getTechnique(i).isActive() && techs.getTechnique(i).getClass() != this.techniques[i].getClass()) {
                    techs.getTechnique(i).deactivate(player);
                }
                techs.setTechnique(i, this.techniques[i]);
                continue;
            }
            Cultivationcraft.LOGGER.warn("Client tried to set invalid technique: " + this.techniques[i].toString());
        }
        PacketHandler.sendCultivatorTechniquesToClient(player);
    }
}

