/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Common.Qi.Elements.Elements;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ElementalEffectPacket
extends Packet {
    ResourceLocation el;
    ResourceKey<Level> lvl;
    BlockPos blockPos;

    public ElementalEffectPacket(ResourceLocation element, ResourceKey<Level> level, BlockPos pos) {
        this.el = element;
        this.lvl = level;
        this.blockPos = pos;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.el);
        buffer.m_236858_(this.lvl);
        buffer.m_130064_(this.blockPos);
    }

    public static ElementalEffectPacket decode(FriendlyByteBuf buffer) {
        ElementalEffectPacket returnValue = new ElementalEffectPacket(null, null, null);
        try {
            ResourceLocation element = buffer.m_130281_();
            ResourceKey level = buffer.m_236801_(Registry.f_122819_);
            BlockPos pos = buffer.m_130135_();
            return new ElementalEffectPacket(element, (ResourceKey<Level>)level, pos);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading ElementalEffectPacket message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isServer()) {
            ctx.enqueueWork(() -> this.processPacket());
        } else {
            Cultivationcraft.LOGGER.warn("Server sent ElementalEffectPacket message");
        }
    }

    protected void processPacket() {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(this.lvl);
        Elements.getElement(this.el).effectBlock((Level)level, this.blockPos);
    }
}

