/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.PlayerHealthManager;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ExternalBloodTickPacket
extends Packet {
    double x;
    double y;
    double z;
    boolean onGround;

    public ExternalBloodTickPacket(double newX, double newY, double newZ, boolean ground) {
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        this.onGround = ground;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeBoolean(this.onGround);
    }

    public static ExternalBloodTickPacket decode(FriendlyByteBuf buffer) {
        ExternalBloodTickPacket returnValue = new ExternalBloodTickPacket(0.0, 0.0, 0.0, false);
        try {
            double newx = buffer.readDouble();
            double newy = buffer.readDouble();
            double newz = buffer.readDouble();
            boolean ground = buffer.readBoolean();
            return new ExternalBloodTickPacket(newx, newy, newz, ground);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading external blood tick message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isServer()) {
            this.processPacket((Player)ctx.getSender());
        } else {
            Cultivationcraft.LOGGER.warn("Client sent external blood tick message");
        }
    }

    protected void processPacket(Player player) {
        PlayerHealthManager.getBlood(player).externalTick(player.f_19853_, this.x, this.y, this.z, this.onGround);
    }
}

