/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPart;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class PartInfoPacket
extends Packet {
    protected String sublimbID;
    protected String limbID;
    protected int info;
    protected UUID player;

    public PartInfoPacket(String subLimbid, String limb, int newInfo, UUID owner) {
        this.sublimbID = subLimbid;
        this.limbID = limb;
        this.info = newInfo;
        this.player = owner;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.info);
        buffer.m_130077_(this.player);
        buffer.m_130070_(this.sublimbID);
        buffer.m_130070_(this.limbID);
    }

    public static PartInfoPacket decode(FriendlyByteBuf buffer) {
        PartInfoPacket returnValue = new PartInfoPacket("", "", -1, null);
        try {
            int readInfo = buffer.readInt();
            UUID readPlayer = buffer.m_130259_();
            String readID = buffer.m_130277_();
            String limbID = buffer.m_130277_();
            return new PartInfoPacket(readID, limbID, readInfo, readPlayer);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading PartInfo message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            ctx.enqueueWork(() -> this.processPacket());
        } else {
            ctx.enqueueWork(() -> this.processPacket(ctx.getSender()));
        }
    }

    protected void processPacket(ServerPlayer sender) {
        BodyPart part = this.sublimbID == "" ? BodyModifications.getBodyModifications((Player)sender).getModification(this.limbID) : BodyModifications.getBodyModifications((Player)sender).getOption(this.limbID, this.sublimbID);
        if (part == null) {
            Cultivationcraft.LOGGER.warn("Exception while reading PartInfo message, part " + this.sublimbID + " doesn't exist for sender");
            return;
        }
        part.processInfo((Player)sender, this.info);
        PacketHandler.sendPartInfoToClients(this, (Player)sender);
    }

    protected void processPacket() {
        Player Player2 = Minecraft.m_91087_().f_91073_.m_46003_(this.player);
        BodyPart part = this.sublimbID == "" ? BodyModifications.getBodyModifications(Player2).getModification(this.limbID) : BodyModifications.getBodyModifications(Player2).getOption(this.limbID, this.sublimbID);
        if (part == null) {
            Cultivationcraft.LOGGER.warn("Exception while reading PartInfo message, part " + this.sublimbID + " doesn't exist for sender");
            return;
        }
        part.processInfo(Player2, this.info);
    }
}

