/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.IBodyModifications;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPart;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartNames;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartOption;
import DaoOfModding.Cultivationcraft.Common.Qi.Stats.BodyPartStatControl;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class QuestCancelPacket
extends Packet {
    @Override
    public void encode(FriendlyByteBuf buffer) {
    }

    public static QuestCancelPacket decode(FriendlyByteBuf buffer) {
        return new QuestCancelPacket();
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isServer()) {
            ctx.enqueueWork(() -> this.processPacket(ctx.getSender().m_20148_()));
        } else {
            Cultivationcraft.LOGGER.warn("Server sent quest cancel message to player");
        }
    }

    protected void processPacket(UUID player) {
        ServerPlayer ownerEntity = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(player);
        IBodyModifications modifications = BodyModifications.getBodyModifications((Player)ownerEntity);
        String lastForged = modifications.getLastForged();
        modifications.setLastForged("");
        BodyPart part = BodyPartNames.getPart(lastForged);
        if (part != null) {
            modifications.removeModification(part);
        } else {
            BodyPartOption option = BodyPartNames.getOption(lastForged);
            modifications.removeOption(option);
        }
        BodyPartStatControl.updateStats((Player)ownerEntity);
        PacketHandler.sendBodyModificationsToClient((Player)ownerEntity);
    }
}

