/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Client.genericClientFunctions;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.QuestHandler;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class QuestPacket
extends Packet {
    UUID player;
    double amount;

    public QuestPacket(UUID playerID, double increase) {
        this.player = playerID;
        this.amount = increase;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.player);
        buffer.writeDouble(this.amount);
    }

    public static QuestPacket decode(FriendlyByteBuf buffer) {
        QuestPacket returnValue = new QuestPacket(null, 0.0);
        try {
            UUID readingPlayer = buffer.m_130259_();
            double readingAmount = buffer.readDouble();
            return new QuestPacket(readingPlayer, readingAmount);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading quest message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isServer()) {
            if (ctx.getSender().m_20148_().compareTo(this.player) != 0) {
                Cultivationcraft.LOGGER.warn("Client sent quest message for other player");
            } else {
                ctx.enqueueWork(() -> this.processPacket());
            }
        } else {
            if (genericClientFunctions.getPlayer() == null) {
                return;
            }
            if (genericClientFunctions.getPlayer().m_20148_().compareTo(this.player) != 0) {
                Cultivationcraft.LOGGER.warn("Server sent quest message for other player");
            } else {
                ctx.enqueueWork(() -> this.processPacketClient());
            }
        }
    }

    protected void processPacket() {
        ServerPlayer ownerEntity = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.player);
        QuestHandler.progressQuest((Player)ownerEntity, this.amount);
    }

    protected void processPacketClient() {
        QuestHandler.progressQuest(genericClientFunctions.getPlayer(), this.amount);
    }
}

