/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import DaoOfModding.Cultivationcraft.StaminaHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class StaminaUsePacket
extends Packet {
    protected float stamina;
    protected UUID entity;

    public StaminaUsePacket(float staminaUse, UUID player) {
        this.stamina = staminaUse;
        this.entity = player;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.stamina);
        buffer.m_130077_(this.entity);
    }

    public static StaminaUsePacket decode(FriendlyByteBuf buffer) {
        StaminaUsePacket returnValue = new StaminaUsePacket(0.0f, null);
        try {
            float stam = buffer.readFloat();
            UUID player = buffer.m_130259_();
            return new StaminaUsePacket(stam, player);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading TechniqueUse message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isServer()) {
            Cultivationcraft.LOGGER.warn("StaminaUsePacket was received by server - This should not happen");
            return;
        }
        ctx.enqueueWork(() -> this.processPacket());
    }

    protected void processPacket() {
        Player player = Minecraft.m_91087_().f_91073_.m_46003_(this.entity);
        if (player != null) {
            StaminaHandler.updateStamina(player, this.stamina);
        }
    }
}

