/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.CultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class TechniqueInfoPacket
extends Packet {
    protected String name;
    protected int info;
    protected UUID player;

    public TechniqueInfoPacket(String langLocation, int newInfo, UUID owner) {
        this.name = langLocation;
        this.info = newInfo;
        this.player = owner;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.name);
        buffer.writeInt(this.info);
        buffer.m_130077_(this.player);
    }

    public static TechniqueInfoPacket decode(FriendlyByteBuf buffer) {
        TechniqueInfoPacket returnValue = new TechniqueInfoPacket("", -1, null);
        try {
            String readName = buffer.m_130277_();
            int readInfo = buffer.readInt();
            UUID readPlayer = buffer.m_130259_();
            return new TechniqueInfoPacket(readName, readInfo, readPlayer);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading TechniqueInfo message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            ctx.enqueueWork(() -> this.processPacket());
        } else {
            ctx.enqueueWork(() -> this.processPacket(ctx.getSender()));
        }
    }

    protected void processPacket(ServerPlayer sender) {
        Technique tech = CultivatorTechniques.getCultivatorTechniques((Player)sender).getTechniqueByName(this.name);
        if (tech != null) {
            tech.processInfo((Player)sender, this.info);
        }
        PacketHandler.sendTechniqueInfoToClients(this, (Player)sender);
    }

    protected void processPacket() {
        Player Player2 = Minecraft.m_91087_().f_91073_.m_46003_(this.player);
        Technique tech = CultivatorTechniques.getCultivatorTechniques(Player2).getTechniqueByName(this.name);
        if (tech != null) {
            tech.processInfo(Player2, this.info);
        }
    }
}

