/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.CultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class TechniqueUsePacket
extends Packet {
    protected int slotNumber;
    protected boolean isKeyDown;

    public TechniqueUsePacket(int slot, boolean keyDown) {
        this.slotNumber = slot;
        this.isKeyDown = keyDown;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.slotNumber);
        buffer.writeBoolean(this.isKeyDown);
    }

    public static TechniqueUsePacket decode(FriendlyByteBuf buffer) {
        TechniqueUsePacket returnValue = new TechniqueUsePacket(-1, false);
        try {
            int readSlot = buffer.readInt();
            boolean readKeyDown = buffer.readBoolean();
            return new TechniqueUsePacket(readSlot, readKeyDown);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading TechniqueUse message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Cultivationcraft.LOGGER.warn("TechniqueUsePacket was received by client - This should not happen");
            return;
        }
        if (this.slotNumber < 0) {
            Cultivationcraft.LOGGER.warn("TechniqueUsePacket was invalid: " + this.toString());
            return;
        }
        ctx.enqueueWork(() -> this.processPacket(ctx.getSender()));
    }

    protected void processPacket(ServerPlayer sender) {
        Technique tech = CultivatorTechniques.getCultivatorTechniques((Player)sender).getTechnique(this.slotNumber);
        if (tech != null) {
            tech.useKeyPressed(this.isKeyDown, (Player)sender);
        }
        PacketHandler.sendCultivatorTechniquesToClient((Player)sender);
    }
}

