/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Common.Qi.Effects.Wind;
import DaoOfModding.Cultivationcraft.Common.Qi.Effects.WindInstance;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class WindPacket
extends Packet {
    WindInstance instance;
    UUID entity;

    public WindPacket(WindInstance wind, UUID entityID) {
        this.instance = wind;
        this.entity = entityID;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.instance.getSpeed());
        buffer.writeFloat(this.instance.getStrength());
        buffer.writeDouble(this.instance.getDirection().f_82479_);
        buffer.writeDouble(this.instance.getDirection().f_82480_);
        buffer.writeDouble(this.instance.getDirection().f_82481_);
        buffer.m_130077_(this.entity);
    }

    public static WindPacket decode(FriendlyByteBuf buffer) {
        WindPacket returnValue = new WindPacket(null, null);
        try {
            float speed = buffer.readFloat();
            float strength = buffer.readFloat();
            Vec3 direction = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            UUID entityID = buffer.m_130259_();
            return new WindPacket(new WindInstance(direction, speed, strength), entityID);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading WindPacket message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isServer()) {
            Cultivationcraft.LOGGER.warn("Client sent WindInstance message");
        } else {
            ctx.enqueueWork(() -> this.processPacket());
        }
    }

    protected void processPacket() {
        Wind.addWindEffectClient(this.entity, this.instance);
    }
}

