/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Network.Packets;

import DaoOfModding.Cultivationcraft.Common.Register;
import DaoOfModding.Cultivationcraft.Cultivationcraft;
import DaoOfModding.Cultivationcraft.Network.Packets.Packet;
import DaoOfModding.Cultivationcraft.Server.ServerItemControl;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class keypressPacket
extends Packet {
    Register.keyPresses keyPress;

    public keypressPacket(Register.keyPresses keyPressed) {
        this.keyPress = keyPressed;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.keyPress);
    }

    public static keypressPacket decode(FriendlyByteBuf buffer) {
        keypressPacket returnValue = new keypressPacket(null);
        try {
            Register.keyPresses readPress = (Register.keyPresses)buffer.m_130066_(Register.keyPresses.class);
            return new keypressPacket(readPress);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Cultivationcraft.LOGGER.warn("Exception while reading keypress message: " + e);
            return returnValue;
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Cultivationcraft.LOGGER.warn("keypressPacket was received by client - This should not happen");
            return;
        }
        if (this.keyPress == null) {
            Cultivationcraft.LOGGER.warn("keypressPacket was invalid: " + this.toString());
            return;
        }
        ctx.enqueueWork(() -> this.processPacket(ctx.getSender()));
    }

    protected void processPacket(ServerPlayer sender) {
        ServerItemControl.handleKeyPress(this.keyPress, sender);
    }
}

