/*
 * Decompiled with CFR 0.152.
 */
package DaoOfModding.Cultivationcraft.Server;

import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.BodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.BodyModifications.IBodyModifications;
import DaoOfModding.Cultivationcraft.Common.Capabilities.ChunkQiSources.IChunkQiSources;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorStats.CultivatorStats;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.CultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.Capabilities.CultivatorTechniques.ICultivatorTechniques;
import DaoOfModding.Cultivationcraft.Common.CommonListeners;
import DaoOfModding.Cultivationcraft.Common.FlyingSwordController;
import DaoOfModding.Cultivationcraft.Common.FlyingSwordEntity;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPart;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.BodyPartOption;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.FoodStats.QiFoodStats;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.PlayerHealthManager;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.Quest;
import DaoOfModding.Cultivationcraft.Common.Qi.BodyParts.Quests.QuestHandler;
import DaoOfModding.Cultivationcraft.Common.Qi.Damage.Damage;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.AttackTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.PassiveTechniques.PassiveTechnique;
import DaoOfModding.Cultivationcraft.Common.Qi.Techniques.Technique;
import DaoOfModding.Cultivationcraft.Network.PacketHandler;
import DaoOfModding.Cultivationcraft.Server.FlyingSwordBindProgresser;
import DaoOfModding.Cultivationcraft.Server.ServerItemControl;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ServerListeners {
    public static long lastServerTickTime = System.nanoTime();
    public static int tick = 0;

    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            QuestHandler.progressQuest(event.player, Quest.TIME_ALIVE, 8.333333333333334E-4);
            QuestHandler.progressQuest(event.player, Quest.LIVE, 8.333333333333334E-4);
            ICultivatorTechniques techs = CultivatorTechniques.getCultivatorTechniques(event.player);
            for (int i = 0; i < 9; ++i) {
                if (techs.getTechnique(i) == null) continue;
                if (techs.getTechnique(i).isValid(event.player)) {
                    if (techs.getTechnique(i).isActive()) {
                        techs.getTechnique(i).tickServer(event);
                        continue;
                    }
                    techs.getTechnique(i).tickInactiveServer(event);
                    continue;
                }
                techs.setTechnique(i, null);
            }
            for (PassiveTechnique passive : techs.getPassives()) {
                if (passive.isActive()) {
                    passive.tickServer(event);
                    continue;
                }
                passive.tickInactiveServer(event);
            }
            IBodyModifications modifications = BodyModifications.getBodyModifications(event.player);
            modifications.setHealth(event.player.m_21223_());
            if (tick % 20 == 0) {
                PlayerHealthManager.getLungs(event.player).breath(event.player);
            }
            for (BodyPart bodyPart : modifications.getModifications().values()) {
                bodyPart.onServerTick(event.player);
            }
            for (HashMap hashMap : modifications.getModificationOptions().values()) {
                for (BodyPartOption part : hashMap.values()) {
                    part.onServerTick(event.player);
                }
            }
            if (CultivatorStats.getCultivatorStats(event.player).getCultivationType() == 0) {
                CultivatorStats.getCultivatorStats(event.player).getCultivation().tick(event.player);
            }
            if (tick % 20 == 0 && event.player.m_36324_() instanceof QiFoodStats && ((QiFoodStats)event.player.m_36324_()).shouldUpdate()) {
                PacketHandler.updateStaminaForClients(((QiFoodStats)event.player.m_36324_()).getTrueFoodLevel(), event.player);
            }
        }
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        if (event.getEntity().f_19853_.f_46443_ || !(event.getEntity() instanceof Player) || !event.getEntity().m_6084_()) {
            return;
        }
        ICultivatorTechniques techs = CultivatorTechniques.getCultivatorTechniques((Player)event.getEntity());
        for (int i = 0; i < 9; ++i) {
            if (techs.getTechnique(i) == null || !techs.getTechnique(i).isActive()) continue;
            techs.getTechnique(i).onFall(event);
        }
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!(event.getTarget() instanceof Player)) {
            return;
        }
        Player target = (Player)event.getTarget();
        PacketHandler.sendBodyModificationsToSpecificClient(target, (ServerPlayer)event.getEntity());
        PacketHandler.sendCultivatorTechniquesToSpecificClient(target, (ServerPlayer)event.getEntity());
        if (target.m_36324_() instanceof QiFoodStats) {
            PacketHandler.updateStaminaForClients(((QiFoodStats)target.m_36324_()).getTrueFoodLevel(), target);
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            tick = (tick + 1) % 800;
            if (ServerItemControl.loaded) {
                FlyingSwordBindProgresser.bindFlyingSword(System.nanoTime() - lastServerTickTime);
            }
            lastServerTickTime = System.nanoTime();
        }
    }

    @SubscribeEvent
    public static void LevelTick(TickEvent.LevelTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        ArrayList ticking = (ArrayList)CommonListeners.tickingQiSources.clone();
        for (IChunkQiSources sources : ticking) {
            if (sources.getDimension().compareTo(event.level.m_46472_().m_135782_()) != 0) continue;
            boolean update = false;
            if (sources.tick(event.level) || tick % 400 == 0) {
                update = true;
            }
            if (!update) continue;
            LevelChunk chunk = event.level.m_6325_(sources.getChunkPos().f_45578_, sources.getChunkPos().f_45579_);
            chunk.m_8092_(true);
            PacketHandler.sendChunkQiSourcesToClient(chunk);
        }
    }

    @SubscribeEvent
    public static void itemThrowEvent(ItemTossEvent event) {
        ItemEntity item;
        if (event.getEntity() instanceof ItemEntity && FlyingSwordController.isFlying((item = event.getEntity()).m_32055_()) && !(event.getEntity() instanceof FlyingSwordEntity)) {
            event.setCanceled(true);
            FlyingSwordController.spawnFlyingSword(item);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        ICultivatorTechniques techs = CultivatorTechniques.getCultivatorTechniques(event.getEntity());
        for (int i = 0; i < 9; ++i) {
            Technique testTech = techs.getTechnique(i);
            if (testTech == null || !testTech.isActive() || !(testTech instanceof AttackTechnique)) continue;
            ((AttackTechnique)testTech).onPlayerAttack(event);
        }
    }

    @SubscribeEvent
    public static void onPlayerHurtInitial(LivingAttackEvent event) {
        if (event.getSource().m_7639_() != null && event.getSource().m_7639_() instanceof Player) {
            ICultivatorTechniques techs = CultivatorTechniques.getCultivatorTechniques((Player)event.getSource().m_7639_());
            for (int i = 0; i < 9; ++i) {
                Technique testTech = techs.getTechnique(i);
                if (testTech == null || !testTech.isActive() || !(testTech instanceof AttackTechnique) || !((AttackTechnique)testTech).cancelAttack(event)) continue;
                event.setCanceled(true);
                return;
            }
        }
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            if (event.getSource().m_19378_()) {
                return;
            }
            if (!CultivatorStats.isCultivator((Player)event.getEntity())) {
                return;
            }
            event.setCanceled(Damage.shouldCancel(event));
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            if (event.getSource().m_19378_()) {
                return;
            }
            if (CultivatorStats.isCultivator((Player)event.getEntity())) {
                event.setAmount(Damage.damage(event));
            }
            Damage.applyStatusEffects(event);
        } else {
            event.setAmount(Damage.damageEntity(event));
            Damage.applyStatusEffects(event);
        }
    }
}

