/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.registry;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.compress.utils.Lists;

public class ResourceRegistry<T> {
    protected final String name;
    protected final Map<ResourceLocation, T> keyToElement = Maps.newConcurrentMap();
    protected final Map<T, ResourceLocation> elementToKey = Maps.newConcurrentMap();

    public ResourceRegistry(String name) {
        this.name = name;
    }

    public void register(ResourceLocation key, T element) {
        this.keyToElement.put(key, element);
        this.elementToKey.put(element, key);
    }

    public Collection<T> listElements() {
        return this.keyToElement.values();
    }

    public Codec<T> byNameCodec() {
        return ResourceLocation.f_135803_.flatXmap(this::tryGetElement, this::tryGetKey);
    }

    public void onReloadStart() {
        this.keyToElement.clear();
        this.elementToKey.clear();
    }

    public void onReloadEnd() {
    }

    public int total() {
        return this.keyToElement.size();
    }

    public String toString() {
        return "ResourceRegistry[" + this.name + "]";
    }

    private DataResult<T> tryGetElement(ResourceLocation key) {
        return Optional.ofNullable(this.keyToElement.get(key)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in %s: %s".formatted(this.toString(), key)));
    }

    private DataResult<ResourceLocation> tryGetKey(T element) {
        return Optional.ofNullable(this.elementToKey.get(element)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in %s: %s".formatted(this.toString(), element)));
    }

    public static class Ordered<T extends Comparable<T>>
    extends ResourceRegistry<T> {
        private final List<T> sortedElements = Lists.newArrayList();

        public Ordered(String name) {
            super(name);
        }

        @Override
        public Collection<T> listElements() {
            return this.sortedElements;
        }

        @Override
        public void onReloadEnd() {
            this.sortedElements.clear();
            this.sortedElements.addAll(this.keyToElement.values());
            this.sortedElements.sort(Comparator.reverseOrder());
        }
    }
}

