/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.client;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.apache.commons.compress.utils.Lists;

public final class TooltipComponentRegistry {
    private static final List<Definition<?>> definitions = Lists.newArrayList();

    public static <T extends TooltipComponent> void register(Class<T> type, Function<T, ClientTooltipComponent> factory) {
        if (definitions.stream().anyMatch(it -> it.type.equals(type))) {
            return;
        }
        definitions.add(new Definition<T>(type, factory));
    }

    public static Optional<ClientTooltipComponent> create(TooltipComponent component) {
        for (Definition<?> definition : definitions) {
            if (!definition.isFor(component)) continue;
            return Optional.of(definition.create(component));
        }
        return Optional.empty();
    }

    private record Definition<T extends TooltipComponent>(Class<T> type, Function<T, ClientTooltipComponent> factory) {
        public boolean isFor(TooltipComponent component) {
            return component.getClass().equals(this.type);
        }

        public ClientTooltipComponent create(TooltipComponent component) {
            return this.factory.apply((TooltipComponent)this.type.cast(component));
        }
    }
}

