/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.forge.registry;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ForgeNetworking {
    public static final Set<String> clientOnlyMods = Sets.newConcurrentHashSet();
    public static final Set<String> serverOnlyMods = Sets.newConcurrentHashSet();
    public static final Map<String, SimpleChannel> channelByMod = Maps.newConcurrentMap();
    public static final Map<Class<?>, SimpleChannel> channelByType = Maps.newConcurrentMap();
    public static final Map<String, Integer> idByMod = Maps.newConcurrentMap();
    public static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable NetworkEvent.Context replyContext;

    public static SimpleChannel getOrCreateChannel(String modId) {
        return channelByMod.computeIfAbsent(modId, key -> {
            ResourceLocation channelName = new ResourceLocation(key, "network");
            NetworkRegistry.ChannelBuilder builder = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channelName);
            if (serverOnlyMods.contains(modId)) {
                builder.clientAcceptedVersions(version -> true);
            }
            if (clientOnlyMods.contains(modId)) {
                builder.serverAcceptedVersions(version -> true);
            }
            return builder.simpleChannel();
        });
    }

    public static SimpleChannel channelFor(Object payload) {
        return Objects.requireNonNull(channelByType.get(payload.getClass()));
    }

    public static int nextIdFor(String modId) {
        return idByMod.compute(modId, (key, prev) -> prev != null ? prev + 1 : 0);
    }
}

