/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.element.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.fragmentum.util.easing.Easing;
import dev.obscuria.fragmentum.util.easing.EasingFunction;
import dev.obscuria.tooltips.client.element.effect.TooltipEffect;
import dev.obscuria.tooltips.client.particle.TooltipParticle;
import dev.obscuria.tooltips.client.renderer.ParticleData;
import dev.obscuria.tooltips.client.renderer.TooltipContext;
import java.util.List;
import net.minecraft.class_241;
import net.minecraft.class_332;
import org.apache.commons.lang3.RandomUtils;

public record IconParticleEffect(TooltipParticle particle) implements TooltipEffect
{
    public static final Codec<IconParticleEffect> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)TooltipParticle.CODEC.fieldOf("particle").forGetter(IconParticleEffect::particle)).apply((Applicative)codec, IconParticleEffect::new));

    public Codec<IconParticleEffect> codec() {
        return CODEC;
    }

    @Override
    public boolean canApply(List<TooltipEffect> effects) {
        return effects.stream().noneMatch(it -> it instanceof IconParticleEffect);
    }

    @Override
    public void renderIcon(class_332 graphics, TooltipContext context, int x, int y) {
        float lastParticleTime = 0.0f;
        for (ParticleData particle : context.particles()) {
            if (!particle.source.equals(this)) continue;
            particle.render(graphics, context, this.particle, x, y);
            lastParticleTime = Math.max(lastParticleTime, particle.startTime);
        }
        if (context.timeInSeconds() - lastParticleTime < 0.15f) {
            return;
        }
        class_241 origin = class_241.field_1340;
        float direction = RandomUtils.nextFloat((float)0.0f, (float)((float)Math.PI * 2));
        class_241 destination = new class_241(12.0f * (float)Math.sin(direction), 12.0f * (float)Math.cos(direction));
        context.addParticle(new IconParticle(this, context.timeInSeconds(), origin, destination));
    }

    private static final class IconParticle
    extends ParticleData {
        public IconParticle(Object source, float startTime, class_241 origin, class_241 destination) {
            super(source, startTime, origin, destination);
        }

        @Override
        public float computeProgress(TooltipContext context) {
            return Easing.EASE_OUT_CUBIC.compute(super.computeProgress(context) * 0.5f);
        }

        @Override
        public float computeScale(TooltipContext context, float progress) {
            return Easing.EASE_OUT_CUBIC.mergeOut((EasingFunction)Easing.EASE_IN_CUBIC, 0.2f).compute(progress * 1.2f);
        }

        @Override
        public float computeRotation(TooltipContext context, float progress) {
            return progress * 2.0f;
        }
    }
}

