/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.renderer;

import dev.obscuria.tooltips.client.TooltipDefinition;
import dev.obscuria.tooltips.client.TooltipLabel;
import dev.obscuria.tooltips.client.renderer.BlankComponent;
import dev.obscuria.tooltips.client.renderer.HeaderComponent;
import dev.obscuria.tooltips.client.renderer.TooltipContext;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;
import net.minecraft.class_8000;
import org.joml.Vector2ic;

public final class TooltipRenderer {
    private static class_1799 lastStack = class_1799.field_8037;
    private static class_1799 actualStack = class_1799.field_8037;
    private static TooltipContext context = new TooltipContext();

    public static void perform(class_1799 stack) {
        actualStack = stack;
        if (class_1799.method_31577((class_1799)lastStack, (class_1799)actualStack)) {
            return;
        }
        context = new TooltipContext(actualStack, TooltipDefinition.aggregateStyleFor(stack), TooltipLabel.findFor(stack));
    }

    public static boolean render(class_332 graphics, class_327 font, List<class_5684> components, int mouseX, int mouseY, class_8000 positioner) {
        if (actualStack.method_7960()) {
            return false;
        }
        if (components.isEmpty()) {
            return false;
        }
        class_5684 title = components.remove(0);
        BlankComponent label = context.label() != null ? context.label().create(actualStack) : BlankComponent.INSTANCE;
        int minWidth = TooltipRenderer.widthOf(components, font);
        components.add(0, new HeaderComponent(minWidth, !components.isEmpty(), context, title, label));
        int width = TooltipRenderer.widthOf(components, font);
        int height = TooltipRenderer.heightOf(components) - 2;
        Vector2ic pos = positioner.method_47944(graphics.method_51421(), graphics.method_51443(), mouseX, mouseY, width, height);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        graphics.method_51452();
        context.style().panel().ifPresent(it -> it.render(graphics, pos.x(), pos.y(), width, height));
        context.style().effects().forEach(it -> it.renderBack(graphics, context, pos.x(), pos.y(), width, height));
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 2.0f);
        context.style().frame().ifPresent(it -> it.render(graphics, pos.x(), pos.y(), width, height));
        graphics.method_51448().method_22909();
        graphics.method_51452();
        int componentY = pos.y();
        for (class_5684 component : components) {
            component.method_32665(font, pos.x(), componentY, graphics.method_51448().method_23760().method_23761(), graphics.method_51450());
            component.method_32666(font, pos.x(), componentY, graphics);
            componentY += component.method_32661();
        }
        graphics.method_51448().method_22909();
        lastStack = actualStack;
        actualStack = class_1799.field_8037;
        context.removeExpiredParticles();
        return true;
    }

    private static int widthOf(List<class_5684> components, class_327 font) {
        int max = 0;
        for (class_5684 component : components) {
            int width = component.method_32664(font);
            if (width <= max) continue;
            max = width;
        }
        return max;
    }

    private static int heightOf(List<class_5684> components) {
        int sum = 0;
        for (class_5684 component : components) {
            sum += component.method_32661();
        }
        return sum;
    }
}

