/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.registry;

import com.google.gson.JsonParser;
import dev.obscuria.tooltips.ObscureTooltips;
import dev.obscuria.tooltips.registry.ResourceKind;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import org.apache.commons.lang3.StringUtils;

public final class TooltipsManager
implements class_4013 {
    public static final TooltipsManager INSTANCE = new TooltipsManager();

    private TooltipsManager() {
    }

    public void method_14491(class_3300 manager) {
        for (ResourceKind kind : ResourceKind.values()) {
            kind.spec.onReloadStart();
            Map resources = manager.method_14488(kind.spec.resourceDir(), this::isValidResource);
            resources.forEach((path, resource) -> this.loadResource(kind, (class_2960)path, (class_3298)resource));
            kind.spec.onReloadEnd();
        }
    }

    private boolean isValidResource(class_2960 path) {
        return path.toString().endsWith(".json");
    }

    private void loadResource(ResourceKind kind, class_2960 path, class_3298 resource) {
        try {
            kind.spec.load(this.extractKey(kind, path), JsonParser.parseReader((Reader)resource.method_43039()));
        }
        catch (IOException exception) {
            ObscureTooltips.LOGGER.error("Failed to load resource {}: {}", (Object)path, (Object)exception.getMessage());
        }
    }

    private class_2960 extractKey(ResourceKind kind, class_2960 path) {
        return path.method_45134(it -> {
            String result = StringUtils.removeStart((String)it, (String)(kind.spec.resourceDir() + "/"));
            result = StringUtils.removeEnd((String)result, (String)".json");
            return result;
        });
    }
}

