/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RadienParticleParticle
extends TextureSheetParticle {
    private final float initialSize;
    private final float initialAlpha;
    private final SpriteSet spriteSet;

    public static RadienParticleParticleProvider provider(SpriteSet spriteSet) {
        return new RadienParticleParticleProvider(spriteSet);
    }

    protected RadienParticleParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.setSize(0.2f, 0.2f);
        this.initialSize = this.quadSize = 0.2f;
        this.alpha = this.initialAlpha = 1.0f;
        this.lifetime = 10;
        this.gravity = 0.0f;
        this.hasPhysics = false;
        this.xd = vx * 0.0;
        this.yd = vy * 0.0;
        this.zd = vz * 0.0;
        this.pickSprite(spriteSet);
    }

    public int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        if (this.age < this.lifetime) {
            float progress = (float)this.age / (float)this.lifetime;
            float easedProgress = progress * progress * (3.0f - 2.0f * progress);
            this.alpha = this.initialAlpha * (1.0f - progress * easedProgress);
            this.quadSize = this.initialSize * (1.0f + 4.0f * easedProgress);
        }
    }

    public static class RadienParticleParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public RadienParticleParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new RadienParticleParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

