/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mayoi.radiationzonereborn.client.model.Modelradien;
import net.mayoi.radiationzonereborn.client.model.animations.radienAnimation;
import net.mayoi.radiationzonereborn.entity.RadienEntity;
import net.mayoi.radiationzonereborn.procedures.RadienRadioProcedure;
import net.mayoi.radiationzonereborn.procedures.RadienShakeProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class RadienRenderer
extends MobRenderer<RadienEntity, Modelradien<RadienEntity>> {
    public RadienRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelradien.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<RadienEntity, Modelradien<RadienEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"radiation_zone_reborn:textures/entities/radien_radio.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, RadienEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (RadienRadioProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelradien)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<RadienEntity, Modelradien<RadienEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"radiation_zone_reborn:textures/entities/radien_glow.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, RadienEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                ((Modelradien)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
            }
        });
    }

    public ResourceLocation getTextureLocation(RadienEntity entity) {
        return ResourceLocation.parse((String)"radiation_zone_reborn:textures/entities/radien.png");
    }

    protected boolean isShaking(RadienEntity entity) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        return RadienShakeProcedure.execute((Entity)entity);
    }

    private static final class AnimatedModel
    extends Modelradien<RadienEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<RadienEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(RadienEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, radienAnimation.idle, ageInTicks, 1.0f);
                this.animateWalk(radienAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                this.animate(entity.animationState2, radienAnimation.attack1, ageInTicks, 1.0f);
                this.animate(entity.animationState3, radienAnimation.attack2, ageInTicks, 1.0f);
                this.animate(entity.animationState4, radienAnimation.angry_start, ageInTicks, 1.0f);
                this.animate(entity.animationState5, radienAnimation.angry_end, ageInTicks, 1.0f);
                this.animate(entity.animationState6, radienAnimation.hurt, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(RadienEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

