/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModEntities;
import net.mayoi.radiationzonereborn.procedures.DecayedGiantAnimationAttack1Procedure;
import net.mayoi.radiationzonereborn.procedures.DecayedGiantAnimationAttack2Procedure;
import net.mayoi.radiationzonereborn.procedures.DecayedGiantAnimationAttack3Procedure;
import net.mayoi.radiationzonereborn.procedures.DecayedGiantAnimationAttack4Procedure;
import net.mayoi.radiationzonereborn.procedures.DecayedGiantAnimationAttack5Procedure;
import net.mayoi.radiationzonereborn.procedures.DecayedGiantAnimationAttack6Procedure;
import net.mayoi.radiationzonereborn.procedures.DecayedGiantAnimationHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedGiantHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedGiantSpawnProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedGiantTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class DecayedGiantEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_attack_type = SynchedEntityData.defineId(DecayedGiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(DecayedGiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(DecayedGiantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_hurt_tick = SynchedEntityData.defineId(DecayedGiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_has_target = SynchedEntityData.defineId(DecayedGiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_hurt = SynchedEntityData.defineId(DecayedGiantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_can_range = SynchedEntityData.defineId(DecayedGiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_hit = SynchedEntityData.defineId(DecayedGiantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_next_range = SynchedEntityData.defineId(DecayedGiantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();
    public final AnimationState animationState7 = new AnimationState();

    public DecayedGiantEntity(EntityType<DecayedGiantEntity> type, Level world) {
        super(type, world);
        this.xpReward = 20;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_attack_type, (Object)0);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_hurt_tick, (Object)0);
        builder.define(DATA_has_target, (Object)0);
        builder.define(DATA_in_hurt, (Object)false);
        builder.define(DATA_can_range, (Object)0);
        builder.define(DATA_hit, (Object)false);
        builder.define(DATA_next_range, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"radiation_zone_reborn:entity.decayed_giant.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"radiation_zone_reborn:entity.decayed_giant.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        DecayedGiantEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        DecayedGiantHurtProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, sourceentity);
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (!world.isClientSide()) {
            LivingEntity livingAttacker;
            ItemStack weapon;
            Entity attacker = damagesource.getEntity();
            amount = attacker instanceof LivingEntity ? ((weapon = (livingAttacker = (LivingEntity)attacker).getMainHandItem()).getItem() instanceof PickaxeItem ? (amount *= 1.5f) : (amount *= 0.75f)) : (amount *= 0.75f);
            amount = Math.max(0.0f, amount);
        }
        return super.hurt(damagesource, amount);
    }

    public boolean isPushable() {
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Dataattack_type", ((Integer)this.entityData.get(DATA_attack_type)).intValue());
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putInt("Datahurt_tick", ((Integer)this.entityData.get(DATA_hurt_tick)).intValue());
        compound.putInt("Datahas_target", ((Integer)this.entityData.get(DATA_has_target)).intValue());
        compound.putBoolean("Datain_hurt", ((Boolean)this.entityData.get(DATA_in_hurt)).booleanValue());
        compound.putInt("Datacan_range", ((Integer)this.entityData.get(DATA_can_range)).intValue());
        compound.putBoolean("Datahit", ((Boolean)this.entityData.get(DATA_hit)).booleanValue());
        compound.putBoolean("Datanext_range", ((Boolean)this.entityData.get(DATA_next_range)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataattack_type")) {
            this.entityData.set(DATA_attack_type, (Object)compound.getInt("Dataattack_type"));
        }
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("Datahurt_tick")) {
            this.entityData.set(DATA_hurt_tick, (Object)compound.getInt("Datahurt_tick"));
        }
        if (compound.contains("Datahas_target")) {
            this.entityData.set(DATA_has_target, (Object)compound.getInt("Datahas_target"));
        }
        if (compound.contains("Datain_hurt")) {
            this.entityData.set(DATA_in_hurt, (Object)compound.getBoolean("Datain_hurt"));
        }
        if (compound.contains("Datacan_range")) {
            this.entityData.set(DATA_can_range, (Object)compound.getInt("Datacan_range"));
        }
        if (compound.contains("Datahit")) {
            this.entityData.set(DATA_hit, (Object)compound.getBoolean("Datahit"));
        }
        if (compound.contains("Datanext_range")) {
            this.entityData.set(DATA_next_range, (Object)compound.getBoolean("Datanext_range"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(DecayedGiantAnimationAttack1Procedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(DecayedGiantAnimationAttack2Procedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(DecayedGiantAnimationAttack3Procedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(DecayedGiantAnimationAttack4Procedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(DecayedGiantAnimationAttack5Procedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(DecayedGiantAnimationHurtProcedure.execute((Entity)this), this.tickCount);
            this.animationState7.animateWhen(DecayedGiantAnimationAttack6Procedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        DecayedGiantTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        DecayedGiantEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)RadiationZoneRebornModEntities.DECAYED_GIANT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return DecayedGiantSpawnProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.17);
        builder = builder.add(Attributes.MAX_HEALTH, 120.0);
        builder = builder.add(Attributes.ARMOR, 2.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 12.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 28.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 4.0);
        return builder;
    }
}

