/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import net.mayoi.radiationzonereborn.procedures.DecayedTotemAnimationAttack1Procedure;
import net.mayoi.radiationzonereborn.procedures.DecayedTotemAnimationAttack2Procedure;
import net.mayoi.radiationzonereborn.procedures.DecayedTotemAnimationAttack3Procedure;
import net.mayoi.radiationzonereborn.procedures.DecayedTotemAnimationAttack4Procedure;
import net.mayoi.radiationzonereborn.procedures.DecayedTotemAnimationAttack5Procedure;
import net.mayoi.radiationzonereborn.procedures.DecayedTotemAnimationAttack6Procedure;
import net.mayoi.radiationzonereborn.procedures.DecayedTotemAnimationHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedTotemAnimationIdleProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedTotemAnimationIdleStartProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedTotemAnimationSleepProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedTotemCanSeePlayerProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedTotemHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.DecayedTotemTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class DecayedTotemEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_in_sleep = SynchedEntityData.defineId(DecayedTotemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_start_tick = SynchedEntityData.defineId(DecayedTotemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(DecayedTotemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_attack_type = SynchedEntityData.defineId(DecayedTotemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(DecayedTotemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_has_target = SynchedEntityData.defineId(DecayedTotemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_hurt = SynchedEntityData.defineId(DecayedTotemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_hurt_tick = SynchedEntityData.defineId(DecayedTotemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_can_range = SynchedEntityData.defineId(DecayedTotemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_has_target_recover = SynchedEntityData.defineId(DecayedTotemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_recover_tick = SynchedEntityData.defineId(DecayedTotemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();
    public final AnimationState animationState7 = new AnimationState();
    public final AnimationState animationState8 = new AnimationState();
    public final AnimationState animationState9 = new AnimationState();
    public final AnimationState animationState10 = new AnimationState();

    public DecayedTotemEntity(EntityType<DecayedTotemEntity> type, Level world) {
        super(type, world);
        this.xpReward = 30;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_in_sleep, (Object)true);
        builder.define(DATA_start_tick, (Object)0);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_attack_type, (Object)0);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_has_target, (Object)0);
        builder.define(DATA_in_hurt, (Object)false);
        builder.define(DATA_hurt_tick, (Object)0);
        builder.define(DATA_can_range, (Object)0);
        builder.define(DATA_has_target_recover, (Object)0);
        builder.define(DATA_recover_tick, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = DecayedTotemEntity.this.getX();
                double y = DecayedTotemEntity.this.getY();
                double z = DecayedTotemEntity.this.getZ();
                DecayedTotemEntity entity = DecayedTotemEntity.this;
                Level world = DecayedTotemEntity.this.level();
                return super.canUse() && DecayedTotemCanSeePlayerProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = DecayedTotemEntity.this.getX();
                double y = DecayedTotemEntity.this.getY();
                double z = DecayedTotemEntity.this.getZ();
                DecayedTotemEntity entity = DecayedTotemEntity.this;
                Level world = DecayedTotemEntity.this.level();
                return super.canContinueToUse() && DecayedTotemCanSeePlayerProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"radiation_zone_reborn:entity.decayed_giant.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"radiation_zone_reborn:entity.decayed_giant.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        boolean isAttackImmune;
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        DecayedTotemEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        DecayedTotemHurtProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, immediatesourceentity);
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        boolean bl = isAttackImmune = (Boolean)this.entityData.get(DATA_in_attack) != false && (Integer)this.entityData.get(DATA_attack_type) == 2 && (Integer)this.entityData.get(DATA_attack_tick) >= 12 && (Integer)this.entityData.get(DATA_attack_tick) <= 50;
        if (((Boolean)this.entityData.get(DATA_in_sleep)).booleanValue() || (Integer)this.entityData.get(DATA_start_tick) > 0 || isAttackImmune) {
            return false;
        }
        if (!world.isClientSide()) {
            LivingEntity livingAttacker;
            ItemStack weapon;
            Entity attacker = damagesource.getEntity();
            amount = attacker instanceof LivingEntity ? ((weapon = (livingAttacker = (LivingEntity)attacker).getMainHandItem()).getItem() instanceof PickaxeItem ? (amount *= 1.5f) : (amount *= 0.75f)) : (amount *= 0.75f);
            amount = Math.max(0.0f, amount);
        }
        return super.hurt(damagesource, amount);
    }

    public boolean isPushable() {
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datain_sleep", ((Boolean)this.entityData.get(DATA_in_sleep)).booleanValue());
        compound.putInt("Datastart_tick", ((Integer)this.entityData.get(DATA_start_tick)).intValue());
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putInt("Dataattack_type", ((Integer)this.entityData.get(DATA_attack_type)).intValue());
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putInt("Datahas_target", ((Integer)this.entityData.get(DATA_has_target)).intValue());
        compound.putBoolean("Datain_hurt", ((Boolean)this.entityData.get(DATA_in_hurt)).booleanValue());
        compound.putInt("Datahurt_tick", ((Integer)this.entityData.get(DATA_hurt_tick)).intValue());
        compound.putInt("Datacan_range", ((Integer)this.entityData.get(DATA_can_range)).intValue());
        compound.putInt("Datahas_target_recover", ((Integer)this.entityData.get(DATA_has_target_recover)).intValue());
        compound.putInt("Datarecover_tick", ((Integer)this.entityData.get(DATA_recover_tick)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datain_sleep")) {
            this.entityData.set(DATA_in_sleep, (Object)compound.getBoolean("Datain_sleep"));
        }
        if (compound.contains("Datastart_tick")) {
            this.entityData.set(DATA_start_tick, (Object)compound.getInt("Datastart_tick"));
        }
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("Dataattack_type")) {
            this.entityData.set(DATA_attack_type, (Object)compound.getInt("Dataattack_type"));
        }
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("Datahas_target")) {
            this.entityData.set(DATA_has_target, (Object)compound.getInt("Datahas_target"));
        }
        if (compound.contains("Datain_hurt")) {
            this.entityData.set(DATA_in_hurt, (Object)compound.getBoolean("Datain_hurt"));
        }
        if (compound.contains("Datahurt_tick")) {
            this.entityData.set(DATA_hurt_tick, (Object)compound.getInt("Datahurt_tick"));
        }
        if (compound.contains("Datacan_range")) {
            this.entityData.set(DATA_can_range, (Object)compound.getInt("Datacan_range"));
        }
        if (compound.contains("Datahas_target_recover")) {
            this.entityData.set(DATA_has_target_recover, (Object)compound.getInt("Datahas_target_recover"));
        }
        if (compound.contains("Datarecover_tick")) {
            this.entityData.set(DATA_recover_tick, (Object)compound.getInt("Datarecover_tick"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(DecayedTotemAnimationSleepProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(DecayedTotemAnimationIdleStartProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(DecayedTotemAnimationIdleProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(true, this.tickCount);
            this.animationState4.animateWhen(DecayedTotemAnimationAttack1Procedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(DecayedTotemAnimationAttack2Procedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(DecayedTotemAnimationAttack3Procedure.execute((Entity)this), this.tickCount);
            this.animationState7.animateWhen(DecayedTotemAnimationAttack4Procedure.execute((Entity)this), this.tickCount);
            this.animationState8.animateWhen(DecayedTotemAnimationAttack5Procedure.execute((Entity)this), this.tickCount);
            this.animationState9.animateWhen(DecayedTotemAnimationHurtProcedure.execute((Entity)this), this.tickCount);
            this.animationState10.animateWhen(DecayedTotemAnimationAttack6Procedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        DecayedTotemTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.17);
        builder = builder.add(Attributes.MAX_HEALTH, 180.0);
        builder = builder.add(Attributes.ARMOR, 4.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 10.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 28.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 4.0);
        return builder;
    }
}

