/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import javax.annotation.Nullable;
import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModEntities;
import net.mayoi.radiationzonereborn.procedures.FrostTortoiseAIHideProcedure;
import net.mayoi.radiationzonereborn.procedures.FrostTortoiseAnimationAttackProcedure;
import net.mayoi.radiationzonereborn.procedures.FrostTortoiseAnimationHide2Procedure;
import net.mayoi.radiationzonereborn.procedures.FrostTortoiseAnimationHideProcedure;
import net.mayoi.radiationzonereborn.procedures.FrostTortoiseAnimationJump2Procedure;
import net.mayoi.radiationzonereborn.procedures.FrostTortoiseAnimationJumpProcedure;
import net.mayoi.radiationzonereborn.procedures.FrostTortoiseSizeProcedure;
import net.mayoi.radiationzonereborn.procedures.FrostTortoiseSpawnProcedure;
import net.mayoi.radiationzonereborn.procedures.FrostTortoiseTickProcedure;
import net.mayoi.radiationzonereborn.procedures.FrostTortoiseWhenSpawnProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class FrostTortoiseEntity
extends PathfinderMob {
    public static final EntityDataAccessor<Integer> DATA_has_target = SynchedEntityData.defineId(FrostTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_type = SynchedEntityData.defineId(FrostTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(FrostTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(FrostTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_in_hide = SynchedEntityData.defineId(FrostTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_hide_tick = SynchedEntityData.defineId(FrostTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_hide_phase = SynchedEntityData.defineId(FrostTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_jump_cd = SynchedEntityData.defineId(FrostTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_health = SynchedEntityData.defineId(FrostTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_is_nuclear = SynchedEntityData.defineId(FrostTortoiseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();

    public FrostTortoiseEntity(EntityType<FrostTortoiseEntity> type, Level world) {
        super(type, world);
        this.xpReward = 5;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_has_target, (Object)0);
        builder.define(DATA_attack_type, (Object)0);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_in_hide, (Object)false);
        builder.define(DATA_hide_tick, (Object)0);
        builder.define(DATA_hide_phase, (Object)0);
        builder.define(DATA_jump_cd, (Object)0);
        builder.define(DATA_health, (Object)0);
        builder.define(DATA_is_nuclear, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal(this, 1.0){

            public boolean canUse() {
                double x = FrostTortoiseEntity.this.getX();
                double y = FrostTortoiseEntity.this.getY();
                double z = FrostTortoiseEntity.this.getZ();
                FrostTortoiseEntity entity = FrostTortoiseEntity.this;
                Level world = FrostTortoiseEntity.this.level();
                return super.canUse() && FrostTortoiseAIHideProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FrostTortoiseEntity.this.getX();
                double y = FrostTortoiseEntity.this.getY();
                double z = FrostTortoiseEntity.this.getZ();
                FrostTortoiseEntity entity = FrostTortoiseEntity.this;
                Level world = FrostTortoiseEntity.this.level();
                return super.canContinueToUse() && FrostTortoiseAIHideProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = FrostTortoiseEntity.this.getX();
                double y = FrostTortoiseEntity.this.getY();
                double z = FrostTortoiseEntity.this.getZ();
                FrostTortoiseEntity entity = FrostTortoiseEntity.this;
                Level world = FrostTortoiseEntity.this.level();
                return super.canUse() && FrostTortoiseAIHideProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FrostTortoiseEntity.this.getX();
                double y = FrostTortoiseEntity.this.getY();
                double z = FrostTortoiseEntity.this.getZ();
                FrostTortoiseEntity entity = FrostTortoiseEntity.this;
                Level world = FrostTortoiseEntity.this.level();
                return super.canContinueToUse() && FrostTortoiseAIHideProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new FloatGoal((Mob)this){

            public boolean canUse() {
                double x = FrostTortoiseEntity.this.getX();
                double y = FrostTortoiseEntity.this.getY();
                double z = FrostTortoiseEntity.this.getZ();
                FrostTortoiseEntity entity = FrostTortoiseEntity.this;
                Level world = FrostTortoiseEntity.this.level();
                return super.canUse() && FrostTortoiseAIHideProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = FrostTortoiseEntity.this.getX();
                double y = FrostTortoiseEntity.this.getY();
                double z = FrostTortoiseEntity.this.getZ();
                FrostTortoiseEntity entity = FrostTortoiseEntity.this;
                Level world = FrostTortoiseEntity.this.level();
                return super.canContinueToUse() && FrostTortoiseAIHideProcedure.execute((Entity)entity);
            }
        });
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.turtle.ambient_land"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.turtle.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.turtle.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        FrostTortoiseWhenSpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Datahas_target", ((Integer)this.entityData.get(DATA_has_target)).intValue());
        compound.putInt("Dataattack_type", ((Integer)this.entityData.get(DATA_attack_type)).intValue());
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putBoolean("Datain_hide", ((Boolean)this.entityData.get(DATA_in_hide)).booleanValue());
        compound.putInt("Datahide_tick", ((Integer)this.entityData.get(DATA_hide_tick)).intValue());
        compound.putInt("Datahide_phase", ((Integer)this.entityData.get(DATA_hide_phase)).intValue());
        compound.putInt("Datajump_cd", ((Integer)this.entityData.get(DATA_jump_cd)).intValue());
        compound.putInt("Datahealth", ((Integer)this.entityData.get(DATA_health)).intValue());
        compound.putBoolean("Datais_nuclear", ((Boolean)this.entityData.get(DATA_is_nuclear)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datahas_target")) {
            this.entityData.set(DATA_has_target, (Object)compound.getInt("Datahas_target"));
        }
        if (compound.contains("Dataattack_type")) {
            this.entityData.set(DATA_attack_type, (Object)compound.getInt("Dataattack_type"));
        }
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("Datain_hide")) {
            this.entityData.set(DATA_in_hide, (Object)compound.getBoolean("Datain_hide"));
        }
        if (compound.contains("Datahide_tick")) {
            this.entityData.set(DATA_hide_tick, (Object)compound.getInt("Datahide_tick"));
        }
        if (compound.contains("Datahide_phase")) {
            this.entityData.set(DATA_hide_phase, (Object)compound.getInt("Datahide_phase"));
        }
        if (compound.contains("Datajump_cd")) {
            this.entityData.set(DATA_jump_cd, (Object)compound.getInt("Datajump_cd"));
        }
        if (compound.contains("Datahealth")) {
            this.entityData.set(DATA_health, (Object)compound.getInt("Datahealth"));
        }
        if (compound.contains("Datais_nuclear")) {
            this.entityData.set(DATA_is_nuclear, (Object)compound.getBoolean("Datais_nuclear"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(FrostTortoiseAnimationAttackProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(FrostTortoiseAnimationJumpProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(FrostTortoiseAnimationJump2Procedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(FrostTortoiseAnimationHideProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(FrostTortoiseAnimationHide2Procedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        FrostTortoiseTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        FrostTortoiseEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)FrostTortoiseSizeProcedure.execute((Entity)entity));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)RadiationZoneRebornModEntities.FROST_TORTOISE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return FrostTortoiseSpawnProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.14);
        builder = builder.add(Attributes.MAX_HEALTH, 40.0);
        builder = builder.add(Attributes.ARMOR, 10.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 4.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 18.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 4.0);
        return builder;
    }
}

