/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import net.mayoi.radiationzonereborn.procedures.GiantrockGolemAnimationAttack1Procedure;
import net.mayoi.radiationzonereborn.procedures.GiantrockGolemAnimationAttack2Procedure;
import net.mayoi.radiationzonereborn.procedures.GiantrockGolemAnimationAttack3Procedure;
import net.mayoi.radiationzonereborn.procedures.GiantrockGolemAnimationAttack4Procedure;
import net.mayoi.radiationzonereborn.procedures.GiantrockGolemAnimationAttack5Procedure;
import net.mayoi.radiationzonereborn.procedures.GiantrockGolemAnimationHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.GiantrockGolemAnimationJump2Procedure;
import net.mayoi.radiationzonereborn.procedures.GiantrockGolemAnimationJumpProcedure;
import net.mayoi.radiationzonereborn.procedures.GiantrockGolemCanRandomWalkProcedure;
import net.mayoi.radiationzonereborn.procedures.GiantrockGolemHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.GiantrockGolemRightClickProcedure;
import net.mayoi.radiationzonereborn.procedures.GiantrockGolemTickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class GiantrockGolemEntity
extends PathfinderMob {
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(GiantrockGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_type = SynchedEntityData.defineId(GiantrockGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(GiantrockGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_has_target = SynchedEntityData.defineId(GiantrockGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_enemy_number = SynchedEntityData.defineId(GiantrockGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_hurt = SynchedEntityData.defineId(GiantrockGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_hurt_number = SynchedEntityData.defineId(GiantrockGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_Pathfinding = SynchedEntityData.defineId(GiantrockGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_is_break = SynchedEntityData.defineId(GiantrockGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_jump2 = SynchedEntityData.defineId(GiantrockGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_jump_cd = SynchedEntityData.defineId(GiantrockGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();
    public final AnimationState animationState7 = new AnimationState();
    public final AnimationState animationState8 = new AnimationState();

    public GiantrockGolemEntity(EntityType<GiantrockGolemEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_attack_type, (Object)0);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_has_target, (Object)0);
        builder.define(DATA_enemy_number, (Object)0);
        builder.define(DATA_in_hurt, (Object)false);
        builder.define(DATA_hurt_number, (Object)0);
        builder.define(DATA_Pathfinding, (Object)false);
        builder.define(DATA_is_break, (Object)false);
        builder.define(DATA_jump2, (Object)false);
        builder.define(DATA_jump_cd, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false, false));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal(this, 1.0){

            public boolean canUse() {
                double x = GiantrockGolemEntity.this.getX();
                double y = GiantrockGolemEntity.this.getY();
                double z = GiantrockGolemEntity.this.getZ();
                GiantrockGolemEntity entity = GiantrockGolemEntity.this;
                Level world = GiantrockGolemEntity.this.level();
                return super.canUse() && GiantrockGolemCanRandomWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = GiantrockGolemEntity.this.getX();
                double y = GiantrockGolemEntity.this.getY();
                double z = GiantrockGolemEntity.this.getZ();
                GiantrockGolemEntity entity = GiantrockGolemEntity.this;
                Level world = GiantrockGolemEntity.this.level();
                return super.canContinueToUse() && GiantrockGolemCanRandomWalkProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = GiantrockGolemEntity.this.getX();
                double y = GiantrockGolemEntity.this.getY();
                double z = GiantrockGolemEntity.this.getZ();
                GiantrockGolemEntity entity = GiantrockGolemEntity.this;
                Level world = GiantrockGolemEntity.this.level();
                return super.canUse() && GiantrockGolemCanRandomWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = GiantrockGolemEntity.this.getX();
                double y = GiantrockGolemEntity.this.getY();
                double z = GiantrockGolemEntity.this.getZ();
                GiantrockGolemEntity entity = GiantrockGolemEntity.this;
                Level world = GiantrockGolemEntity.this.level();
                return super.canContinueToUse() && GiantrockGolemCanRandomWalkProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.iron_golem.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.iron_golem.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.iron_golem.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        GiantrockGolemEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        GiantrockGolemHurtProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, immediatesourceentity);
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (!world.isClientSide()) {
            LivingEntity livingAttacker;
            ItemStack weapon;
            Entity attacker = damagesource.getEntity();
            amount = attacker instanceof LivingEntity ? ((weapon = (livingAttacker = (LivingEntity)attacker).getMainHandItem()).getItem() instanceof PickaxeItem ? (amount *= 1.5f) : (amount *= 0.75f)) : (amount *= 0.75f);
            amount = Math.max(0.0f, amount);
        }
        return super.hurt(damagesource, amount);
    }

    public boolean isPushable() {
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putInt("Dataattack_type", ((Integer)this.entityData.get(DATA_attack_type)).intValue());
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putInt("Datahas_target", ((Integer)this.entityData.get(DATA_has_target)).intValue());
        compound.putInt("Dataenemy_number", ((Integer)this.entityData.get(DATA_enemy_number)).intValue());
        compound.putBoolean("Datain_hurt", ((Boolean)this.entityData.get(DATA_in_hurt)).booleanValue());
        compound.putInt("Datahurt_number", ((Integer)this.entityData.get(DATA_hurt_number)).intValue());
        compound.putBoolean("DataPathfinding", ((Boolean)this.entityData.get(DATA_Pathfinding)).booleanValue());
        compound.putBoolean("Datais_break", ((Boolean)this.entityData.get(DATA_is_break)).booleanValue());
        compound.putBoolean("Datajump2", ((Boolean)this.entityData.get(DATA_jump2)).booleanValue());
        compound.putInt("Datajump_cd", ((Integer)this.entityData.get(DATA_jump_cd)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("Dataattack_type")) {
            this.entityData.set(DATA_attack_type, (Object)compound.getInt("Dataattack_type"));
        }
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("Datahas_target")) {
            this.entityData.set(DATA_has_target, (Object)compound.getInt("Datahas_target"));
        }
        if (compound.contains("Dataenemy_number")) {
            this.entityData.set(DATA_enemy_number, (Object)compound.getInt("Dataenemy_number"));
        }
        if (compound.contains("Datain_hurt")) {
            this.entityData.set(DATA_in_hurt, (Object)compound.getBoolean("Datain_hurt"));
        }
        if (compound.contains("Datahurt_number")) {
            this.entityData.set(DATA_hurt_number, (Object)compound.getInt("Datahurt_number"));
        }
        if (compound.contains("DataPathfinding")) {
            this.entityData.set(DATA_Pathfinding, (Object)compound.getBoolean("DataPathfinding"));
        }
        if (compound.contains("Datais_break")) {
            this.entityData.set(DATA_is_break, (Object)compound.getBoolean("Datais_break"));
        }
        if (compound.contains("Datajump2")) {
            this.entityData.set(DATA_jump2, (Object)compound.getBoolean("Datajump2"));
        }
        if (compound.contains("Datajump_cd")) {
            this.entityData.set(DATA_jump_cd, (Object)compound.getInt("Datajump_cd"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        super.mobInteract(sourceentity, hand);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        GiantrockGolemEntity entity = this;
        Level world = this.level();
        return GiantrockGolemRightClickProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, itemstack);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(GiantrockGolemAnimationAttack1Procedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(GiantrockGolemAnimationAttack2Procedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(GiantrockGolemAnimationAttack3Procedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(GiantrockGolemAnimationAttack4Procedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(GiantrockGolemAnimationAttack5Procedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(GiantrockGolemAnimationJumpProcedure.execute((Entity)this), this.tickCount);
            this.animationState7.animateWhen(GiantrockGolemAnimationJump2Procedure.execute((Entity)this), this.tickCount);
            this.animationState8.animateWhen(GiantrockGolemAnimationHurtProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        LivingEntity target = this.getTarget();
        if (target != null && target instanceof Player) {
            this.setTarget(null);
        }
        super.baseTick();
        GiantrockGolemTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.1f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.14);
        builder = builder.add(Attributes.MAX_HEALTH, 190.0);
        builder = builder.add(Attributes.ARMOR, 8.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 15.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 20.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 4.0);
        return builder;
    }
}

