/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModEntities;
import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModItems;
import net.mayoi.radiationzonereborn.procedures.LittleFluorescenceAnimationAttackProcedure;
import net.mayoi.radiationzonereborn.procedures.LittleFluorescenceAttackMonsterProcedure;
import net.mayoi.radiationzonereborn.procedures.LittleFluorescenceAttackPlayerProcedure;
import net.mayoi.radiationzonereborn.procedures.LittleFluorescenceCanFollowProcedure;
import net.mayoi.radiationzonereborn.procedures.LittleFluorescenceCanRandomWalkProcedure;
import net.mayoi.radiationzonereborn.procedures.LittleFluorescenceClickProcedure;
import net.mayoi.radiationzonereborn.procedures.LittleFluorescenceHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.LittleFluorescenceSizeProcedure;
import net.mayoi.radiationzonereborn.procedures.LittleFluorescenceTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class LittleFluorescenceEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Integer> DATA_has_target = SynchedEntityData.defineId(LittleFluorescenceEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(LittleFluorescenceEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(LittleFluorescenceEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_Pathfinding = SynchedEntityData.defineId(LittleFluorescenceEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_is_angry = SynchedEntityData.defineId(LittleFluorescenceEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_recover = SynchedEntityData.defineId(LittleFluorescenceEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_particle = SynchedEntityData.defineId(LittleFluorescenceEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_state = SynchedEntityData.defineId(LittleFluorescenceEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_size = SynchedEntityData.defineId(LittleFluorescenceEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();

    public LittleFluorescenceEntity(EntityType<LittleFluorescenceEntity> type, Level world) {
        super(type, world);
        this.xpReward = 4;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_has_target, (Object)0);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_Pathfinding, (Object)false);
        builder.define(DATA_is_angry, (Object)false);
        builder.define(DATA_recover, (Object)0);
        builder.define(DATA_particle, (Object)0);
        builder.define(DATA_state, (Object)0);
        builder.define(DATA_size, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                double x = LittleFluorescenceEntity.this.getX();
                double y = LittleFluorescenceEntity.this.getY();
                double z = LittleFluorescenceEntity.this.getZ();
                LittleFluorescenceEntity entity = LittleFluorescenceEntity.this;
                Level world = LittleFluorescenceEntity.this.level();
                return super.canUse() && LittleFluorescenceCanFollowProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = LittleFluorescenceEntity.this.getX();
                double y = LittleFluorescenceEntity.this.getY();
                double z = LittleFluorescenceEntity.this.getZ();
                LittleFluorescenceEntity entity = LittleFluorescenceEntity.this;
                Level world = LittleFluorescenceEntity.this.level();
                return super.canContinueToUse() && LittleFluorescenceCanFollowProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false, false){

            public boolean canUse() {
                double x = LittleFluorescenceEntity.this.getX();
                double y = LittleFluorescenceEntity.this.getY();
                double z = LittleFluorescenceEntity.this.getZ();
                LittleFluorescenceEntity entity = LittleFluorescenceEntity.this;
                Level world = LittleFluorescenceEntity.this.level();
                return super.canUse() && LittleFluorescenceAttackMonsterProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = LittleFluorescenceEntity.this.getX();
                double y = LittleFluorescenceEntity.this.getY();
                double z = LittleFluorescenceEntity.this.getZ();
                LittleFluorescenceEntity entity = LittleFluorescenceEntity.this;
                Level world = LittleFluorescenceEntity.this.level();
                return super.canContinueToUse() && LittleFluorescenceAttackMonsterProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = LittleFluorescenceEntity.this.getX();
                double y = LittleFluorescenceEntity.this.getY();
                double z = LittleFluorescenceEntity.this.getZ();
                LittleFluorescenceEntity entity = LittleFluorescenceEntity.this;
                Level world = LittleFluorescenceEntity.this.level();
                return super.canUse() && LittleFluorescenceAttackPlayerProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = LittleFluorescenceEntity.this.getX();
                double y = LittleFluorescenceEntity.this.getY();
                double z = LittleFluorescenceEntity.this.getZ();
                LittleFluorescenceEntity entity = LittleFluorescenceEntity.this;
                Level world = LittleFluorescenceEntity.this.level();
                return super.canContinueToUse() && LittleFluorescenceAttackPlayerProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = LittleFluorescenceEntity.this.getX();
                double y = LittleFluorescenceEntity.this.getY();
                double z = LittleFluorescenceEntity.this.getZ();
                LittleFluorescenceEntity entity = LittleFluorescenceEntity.this;
                Level world = LittleFluorescenceEntity.this.level();
                return super.canUse() && LittleFluorescenceCanRandomWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = LittleFluorescenceEntity.this.getX();
                double y = LittleFluorescenceEntity.this.getY();
                double z = LittleFluorescenceEntity.this.getZ();
                LittleFluorescenceEntity entity = LittleFluorescenceEntity.this;
                Level world = LittleFluorescenceEntity.this.level();
                return super.canContinueToUse() && LittleFluorescenceCanRandomWalkProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = LittleFluorescenceEntity.this.getX();
                double y = LittleFluorescenceEntity.this.getY();
                double z = LittleFluorescenceEntity.this.getZ();
                LittleFluorescenceEntity entity = LittleFluorescenceEntity.this;
                Level world = LittleFluorescenceEntity.this.level();
                return super.canUse() && LittleFluorescenceCanRandomWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = LittleFluorescenceEntity.this.getX();
                double y = LittleFluorescenceEntity.this.getY();
                double z = LittleFluorescenceEntity.this.getZ();
                LittleFluorescenceEntity entity = LittleFluorescenceEntity.this;
                Level world = LittleFluorescenceEntity.this.level();
                return super.canContinueToUse() && LittleFluorescenceCanRandomWalkProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.amethyst_block.hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.amethyst_block.break"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        LittleFluorescenceEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        LittleFluorescenceHurtProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, immediatesourceentity);
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (!world.isClientSide()) {
            LivingEntity livingAttacker;
            ItemStack weapon;
            Entity attacker = damagesource.getEntity();
            amount = attacker instanceof LivingEntity ? ((weapon = (livingAttacker = (LivingEntity)attacker).getMainHandItem()).getItem() instanceof PickaxeItem ? (amount *= 1.5f) : (amount *= 0.75f)) : (amount *= 0.75f);
            amount = Math.max(0.0f, amount);
        }
        return super.hurt(damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Datahas_target", ((Integer)this.entityData.get(DATA_has_target)).intValue());
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putBoolean("DataPathfinding", ((Boolean)this.entityData.get(DATA_Pathfinding)).booleanValue());
        compound.putBoolean("Datais_angry", ((Boolean)this.entityData.get(DATA_is_angry)).booleanValue());
        compound.putInt("Datarecover", ((Integer)this.entityData.get(DATA_recover)).intValue());
        compound.putInt("Dataparticle", ((Integer)this.entityData.get(DATA_particle)).intValue());
        compound.putInt("Datastate", ((Integer)this.entityData.get(DATA_state)).intValue());
        compound.putInt("Datasize", ((Integer)this.entityData.get(DATA_size)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datahas_target")) {
            this.entityData.set(DATA_has_target, (Object)compound.getInt("Datahas_target"));
        }
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("DataPathfinding")) {
            this.entityData.set(DATA_Pathfinding, (Object)compound.getBoolean("DataPathfinding"));
        }
        if (compound.contains("Datais_angry")) {
            this.entityData.set(DATA_is_angry, (Object)compound.getBoolean("Datais_angry"));
        }
        if (compound.contains("Datarecover")) {
            this.entityData.set(DATA_recover, (Object)compound.getInt("Datarecover"));
        }
        if (compound.contains("Dataparticle")) {
            this.entityData.set(DATA_particle, (Object)compound.getInt("Dataparticle"));
        }
        if (compound.contains("Datastate")) {
            this.entityData.set(DATA_state, (Object)compound.getInt("Datastate"));
        }
        if (compound.contains("Datasize")) {
            this.entityData.set(DATA_size, (Object)compound.getInt("Datasize"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        if (!((Boolean)this.entityData.get(DATA_is_angry)).booleanValue()) {
            ItemStack itemstack = sourceentity.getItemInHand(hand);
            InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            Item item = itemstack.getItem();
            if (itemstack.getItem() instanceof SpawnEggItem) {
                retval = super.mobInteract(sourceentity, hand);
            } else if (this.level().isClientSide()) {
                retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
            } else if (this.isTame()) {
                if (this.isOwnedBy((LivingEntity)sourceentity)) {
                    if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                        this.usePlayerItem(sourceentity, hand, itemstack);
                        FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                        float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                        this.heal(nutrition);
                        retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                    } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                        this.usePlayerItem(sourceentity, hand, itemstack);
                        this.heal(4.0f);
                        retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                    } else {
                        retval = super.mobInteract(sourceentity, hand);
                    }
                }
            } else if (this.isFood(itemstack)) {
                this.usePlayerItem(sourceentity, hand, itemstack);
                if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                    this.tame(sourceentity);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
                this.setPersistenceRequired();
                retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            } else {
                retval = super.mobInteract(sourceentity, hand);
                if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                    this.setPersistenceRequired();
                }
            }
            double x = this.getX();
            double y = this.getY();
            double z = this.getZ();
            LittleFluorescenceEntity entity = this;
            Level world = this.level();
            return LittleFluorescenceClickProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity, itemstack);
        }
        return InteractionResult.PASS;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState1.animateWhen(LittleFluorescenceAnimationAttackProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        LittleFluorescenceTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        LittleFluorescenceEntity retval = (LittleFluorescenceEntity)((EntityType)RadiationZoneRebornModEntities.LITTLE_FLUORESCENCE.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RadiationZoneRebornModItems.RADIANCE_CRYSTAL_SHARD.get())}).test(stack);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        LittleFluorescenceEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)LittleFluorescenceSizeProcedure.execute((Entity)entity));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.24);
        builder = builder.add(Attributes.MAX_HEALTH, 12.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

