/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModEntities;
import net.mayoi.radiationzonereborn.procedures.RadiationSkeletonAnimationAttack1Procedure;
import net.mayoi.radiationzonereborn.procedures.RadiationSkeletonAnimationAttack2Procedure;
import net.mayoi.radiationzonereborn.procedures.RadiationSkeletonSpawnProcedure;
import net.mayoi.radiationzonereborn.procedures.RadiationSkeletonTickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class RadiationSkeletonEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_in_attack1 = SynchedEntityData.defineId(RadiationSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_in_attack2 = SynchedEntityData.defineId(RadiationSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_attack1_tick = SynchedEntityData.defineId(RadiationSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack2_tick = SynchedEntityData.defineId(RadiationSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();

    public RadiationSkeletonEntity(EntityType<RadiationSkeletonEntity> type, Level world) {
        super(type, world);
        this.xpReward = 4;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_in_attack1, (Object)false);
        builder.define(DATA_in_attack2, (Object)false);
        builder.define(DATA_attack1_tick, (Object)0);
        builder.define(DATA_attack2_tick, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.skeleton.ambient"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.skeleton.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.skeleton.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.skeleton.death"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datain_attack1", ((Boolean)this.entityData.get(DATA_in_attack1)).booleanValue());
        compound.putBoolean("Datain_attack2", ((Boolean)this.entityData.get(DATA_in_attack2)).booleanValue());
        compound.putInt("Dataattack1_tick", ((Integer)this.entityData.get(DATA_attack1_tick)).intValue());
        compound.putInt("Dataattack2_tick", ((Integer)this.entityData.get(DATA_attack2_tick)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datain_attack1")) {
            this.entityData.set(DATA_in_attack1, (Object)compound.getBoolean("Datain_attack1"));
        }
        if (compound.contains("Datain_attack2")) {
            this.entityData.set(DATA_in_attack2, (Object)compound.getBoolean("Datain_attack2"));
        }
        if (compound.contains("Dataattack1_tick")) {
            this.entityData.set(DATA_attack1_tick, (Object)compound.getInt("Dataattack1_tick"));
        }
        if (compound.contains("Dataattack2_tick")) {
            this.entityData.set(DATA_attack2_tick, (Object)compound.getInt("Dataattack2_tick"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState2.animateWhen(RadiationSkeletonAnimationAttack1Procedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(RadiationSkeletonAnimationAttack2Procedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        RadiationSkeletonTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)RadiationZoneRebornModEntities.RADIATION_SKELETON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return RadiationSkeletonSpawnProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.26);
        builder = builder.add(Attributes.MAX_HEALTH, 24.0);
        builder = builder.add(Attributes.ARMOR, 6.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

