/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.datagen.util;

import com.github.mim1q.minecells.datagen.util.DatagenBlockSetUtils;
import com.github.mim1q.minecells.datagen.util.DatagenUtils;
import com.github.mim1q.minecells.datagen.util.specific.CellCrafterRecipeProvider;
import com.github.mim1q.minecells.recipe.CellForgeRecipe;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricAdvancementProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.SimpleFabricLootTableProvider;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_8779;
import net.minecraft.class_8790;

public abstract class AllDatagenUtils
implements DataGeneratorEntrypoint,
DatagenBlockSetUtils {
    private DatagenUtils.InitializerHolder initializers = DatagenUtils.InitializerHolder.createEmpty();

    public abstract void initialize();

    @Override
    public DatagenUtils.InitializerHolder getInitializers() {
        return this.initializers;
    }

    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        this.initializers = DatagenUtils.InitializerHolder.createEmpty();
        this.initialize();
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(x$0 -> new Models(x$0));
        pack.addProvider((x$0, x$1) -> new Recipe(x$0, x$1));
        pack.addProvider((x$0, x$1) -> new CellCrafterRecipes(x$0, x$1));
        List.of(class_173.field_1175, class_173.field_1179, class_173.field_20761, class_173.field_20762, class_173.field_1176, class_173.field_1173, class_173.field_50217, class_173.field_42858, class_173.field_16235, class_173.field_22403, class_173.field_48928, class_173.field_1174, class_173.field_24423, class_173.field_44788, class_173.field_48381, class_173.field_1177, class_173.field_1172, class_173.field_49446, class_173.field_51801, class_173.field_51802, class_173.field_51803, class_173.field_51804, class_173.field_52067).forEach(it -> pack.addProvider(this.createOtherLootTable((class_176)it)));
        pack.addProvider((x$0, x$1) -> new BlockLootTable(x$0, x$1));
        pack.addProvider((x$0, x$1) -> new BlockTags(x$0, x$1));
        pack.addProvider((x$0, x$1) -> new ItemTags(x$0, x$1));
        pack.addProvider((x$0, x$1) -> new FluidTags(x$0, x$1));
        pack.addProvider((x$0, x$1) -> new EntityTags(x$0, x$1));
        pack.addProvider((x$0, x$1) -> new BlockEntityTags(x$0, x$1));
        pack.addProvider((x$0, x$1) -> new EnchantmentTags(x$0, x$1));
        pack.addProvider((x$0, x$1) -> new Advancement(x$0, x$1));
    }

    private FabricDataGenerator.Pack.RegistryDependentFactory<SimpleFabricLootTableProvider> createOtherLootTable(class_176 type) {
        return (output, registryLookup) -> new OtherLootTable(output, registryLookup, type);
    }

    private static <T> void configureTags(Function<class_6862<T>, FabricTagProvider.FabricTagBuilder> provider, Map<class_6862<T>, List<Consumer<FabricTagProvider.FabricTagBuilder>>> map) {
        map.forEach((tag, values) -> {
            FabricTagProvider.FabricTagBuilder builder = (FabricTagProvider.FabricTagBuilder)provider.apply((class_6862)tag);
            values.forEach(it -> it.accept(builder));
        });
    }

    private class OtherLootTable
    extends SimpleFabricLootTableProvider {
        public OtherLootTable(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup, class_176 lootContextType) {
            super(output, registryLookup, lootContextType);
        }

        public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> lootTableBiConsumer) {
            List<Consumer<BiConsumer<class_5321<class_52>, class_52.class_53>>> list = AllDatagenUtils.this.getInitializers().otherLootTable().get(this.lootContextType);
            if (list != null) {
                list.forEach(it -> it.accept(lootTableBiConsumer));
            }
        }
    }

    private class Advancement
    extends FabricAdvancementProvider {
        protected Advancement(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, registryLookup);
        }

        public void generateAdvancement(class_7225.class_7874 registryLookup, Consumer<class_8779> consumer) {
            AllDatagenUtils.this.getInitializers().advancements().forEach(consumer);
        }
    }

    private class EnchantmentTags
    extends FabricTagProvider.EnchantmentTagProvider {
        public EnchantmentTags(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            AllDatagenUtils.configureTags(x$0 -> this.getOrCreateTagBuilder((class_6862)x$0), AllDatagenUtils.this.getInitializers().tags().enchantmentTags);
        }
    }

    private class BlockEntityTags
    extends FabricTagProvider.BlockEntityTypeTagProvider {
        public BlockEntityTags(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            AllDatagenUtils.configureTags(x$0 -> this.getOrCreateTagBuilder((class_6862)x$0), AllDatagenUtils.this.getInitializers().tags().blockEntityTags);
        }
    }

    private class EntityTags
    extends FabricTagProvider.EntityTypeTagProvider {
        public EntityTags(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            AllDatagenUtils.configureTags(x$0 -> this.getOrCreateTagBuilder((class_6862)x$0), AllDatagenUtils.this.getInitializers().tags().entityTags);
        }
    }

    private class FluidTags
    extends FabricTagProvider.FluidTagProvider {
        public FluidTags(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            AllDatagenUtils.configureTags(x$0 -> this.getOrCreateTagBuilder((class_6862)x$0), AllDatagenUtils.this.getInitializers().tags().fluidTags);
        }
    }

    private class ItemTags
    extends FabricTagProvider.ItemTagProvider {
        public ItemTags(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            AllDatagenUtils.configureTags(x$0 -> this.getOrCreateTagBuilder((class_6862)x$0), AllDatagenUtils.this.getInitializers().tags().itemTags);
        }
    }

    private class BlockTags
    extends FabricTagProvider.BlockTagProvider {
        public BlockTags(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            AllDatagenUtils.configureTags(x$0 -> this.getOrCreateTagBuilder((class_6862)x$0), AllDatagenUtils.this.getInitializers().tags().blockTags);
        }
    }

    private class BlockLootTable
    extends FabricBlockLootTableProvider {
        protected BlockLootTable(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void method_10379() {
            AllDatagenUtils.this.getInitializers().blockLootTable().forEach(it -> it.accept(this));
        }
    }

    private class CellCrafterRecipes
    extends CellCrafterRecipeProvider {
        protected CellCrafterRecipes(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(dataOutput, registriesFuture);
        }

        protected void configure(BiConsumer<class_2960, CellForgeRecipe> provider, class_7225.class_7874 lookup) {
            AllDatagenUtils.this.getInitializers().cellCrafterRecipes().forEach(it -> provider.accept(it.id(), (CellForgeRecipe)it));
        }
    }

    private class Recipe
    extends FabricRecipeProvider {
        public Recipe(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        public void method_10419(class_8790 exporter) {
            AllDatagenUtils.this.getInitializers().recipe().forEach(it -> it.accept(exporter));
        }
    }

    private class Models
    extends FabricModelProvider {
        public Models(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
            AllDatagenUtils.this.getInitializers().blockState().forEach(it -> it.accept(blockStateModelGenerator));
        }

        public void generateItemModels(class_4915 itemModelGenerator) {
            AllDatagenUtils.this.getInitializers().itemModel().forEach(it -> it.accept(itemModelGenerator));
        }
    }
}

