/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.entity.MineCellsEntity;
import com.github.mim1q.minecells.entity.ai.goal.TimedActionGoal;
import com.github.mim1q.minecells.entity.ai.goal.TimedDashGoal;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.ParticleUtils;
import com.github.mim1q.minecells.util.animation.AnimationProperty;
import com.google.common.collect.HashMultimap;
import java.util.function.Consumer;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

public class SewersTentacleEntity
extends MineCellsEntity {
    public final AnimationProperty belowGround = new AnimationProperty(-2.0f, MathUtils::easeInOutQuad);
    public final AnimationProperty wobble = new AnimationProperty(0.0f, MathUtils::easeInOutQuad);
    public final AnimationProperty wobbleOffset = new AnimationProperty(0.0f, MathUtils::easeInOutQuad);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(SewersTentacleEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> BURIED = class_2945.method_12791(SewersTentacleEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SPAWNED_BY_BOSS = class_2945.method_12791(SewersTentacleEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DASH_CHARGING = class_2945.method_12791(SewersTentacleEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DASH_RELEASING = class_2945.method_12791(SewersTentacleEntity.class, (class_2941)class_2943.field_13323);
    private static final HashMultimap<class_6880<class_1320>, class_1322> bossModifiers = HashMultimap.create();
    private int buriedTicks = 0;
    private int dashCooldown = 100;
    private float stepHeight = 0.5f;

    public SewersTentacleEntity(class_1299<SewersTentacleEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.updateAttributeModifiers();
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)0);
        builder.method_56912(BURIED, (Object)true);
        builder.method_56912(SPAWNED_BY_BOSS, (Object)false);
        builder.method_56912(DASH_CHARGING, (Object)false);
        builder.method_56912(DASH_RELEASING, (Object)false);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new TentacleAttackGoal(this, 1.2));
        this.field_6201.method_6277(0, (class_1352)new TentacleSweepGoal(this, s -> {
            s.cooldownSetter = cooldown -> {
                this.dashCooldown = cooldown;
            };
            s.cooldownGetter = () -> this.dashCooldown;
            s.stateSetter = this::switchDashState;
            s.speed = 0.4f;
            s.onGround = true;
            s.damage = 6.0f;
            s.defaultCooldown = 100;
            s.actionTick = 5;
            s.alignTick = 4;
            s.chance = 0.075f;
            s.length = 80;
            s.margin = 0.25;
        }));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, 0, false, false, null));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    private void switchDashState(TimedActionGoal.State state, boolean value) {
        if (state == TimedActionGoal.State.CHARGE && value) {
            this.setBuried(false);
            this.stepHeight = 0.0f;
        }
        if (state == TimedActionGoal.State.RELEASE && !value) {
            this.setBuried(true);
            this.stepHeight = 1.0f;
        }
        switch (state) {
            case CHARGE: {
                this.field_6011.method_12778(DASH_CHARGING, (Object)value);
                break;
            }
            case RELEASE: {
                this.field_6011.method_12778(DASH_RELEASING, (Object)value);
            }
        }
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.updateAttributeModifiers();
        float chance = this.field_5974.method_43057();
        int variant = 0;
        if (chance > 0.5f) {
            variant = chance > 0.83f ? 2 : 1;
        }
        this.setVariant(variant);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public float method_49476() {
        return this.stepHeight;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.spawnMovingParticles();
            if (this.method_5805()) {
                if (this.isBuried()) {
                    this.belowGround.setupTransitionTo(-2.5f, 20.0f);
                    this.wobble.setupTransitionTo(0.0f, 15.0f);
                } else {
                    this.belowGround.setupTransitionTo(0.0f, 10.0f);
                    this.wobble.setupTransitionTo(1.0f, 20.0f);
                }
                if (this.getStateFromTrackedData(DASH_CHARGING, DASH_RELEASING) == TimedActionGoal.State.IDLE) {
                    this.wobbleOffset.setupTransitionTo(0.0f, 20.0f);
                } else {
                    this.wobbleOffset.setupTransitionTo(1.0f, 10.0f);
                }
            }
        } else if (this.isSpawnedByBoss() && this.field_6012 > 3600 && this.field_6012 % 20 == 0) {
            this.method_5643(this.method_37908().method_48963().method_48834(), 5.0f);
        }
        --this.dashCooldown;
        this.buriedTicks = this.isBuried() ? this.buriedTicks + 1 : 0;
    }

    protected void method_6108() {
        this.belowGround.setupTransitionTo(-2.5f, 10.0f);
        super.method_6108();
    }

    private void updateAttributeModifiers() {
        this.method_6127().method_59935(bossModifiers);
        if (this.isSpawnedByBoss()) {
            this.method_6127().method_59932(bossModifiers);
        }
    }

    protected void spawnMovingParticles() {
        class_2680 blockState = this.method_37908().method_8320(class_2338.method_49638((class_2374)this.method_19538().method_1023(0.0, (double)0.01f, 0.0)));
        if (blockState != null && blockState.method_26225()) {
            class_2388 particle = new class_2388(class_2398.field_11217, blockState);
            ParticleUtils.addInBox(this.method_37908(), (class_2394)particle, class_238.method_30048((class_243)this.method_19538().method_1031(0.0, 0.125, 0.0), (double)1.0, (double)0.25, (double)1.0), this.isBuried() ? 10 : 5, new class_243(-0.01, -0.01, -0.01));
        }
    }

    @Override
    public boolean method_5679(class_1282 damageSource) {
        if (damageSource.method_48789(class_8103.field_42249) || damageSource.method_49708(class_8111.field_42347) || damageSource.method_49708(class_8111.field_44869) || damageSource.method_5530() || damageSource.method_49708(class_8111.field_42352)) {
            return false;
        }
        if (this.isBuried() && this.buriedTicks > 20 || damageSource.method_49708(class_8111.field_42340)) {
            return true;
        }
        return super.method_5679(damageSource);
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_30949(class_1297 other) {
        if (other instanceof SewersTentacleEntity) {
            return true;
        }
        if (this.isBuried()) {
            return false;
        }
        return super.method_30949(other);
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public boolean method_5767() {
        return this.isBuried() && (this.buriedTicks > 20 || this.field_6012 <= 20);
    }

    public static class_5132.class_5133 createSewersTentacleAttributes() {
        return SewersTentacleEntity.method_26918().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23724, 2.5).method_26868(class_5134.field_23719, 0.22).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23722, 2.0).method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23718, 1.0);
    }

    public int getVariant() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public boolean isBuried() {
        return (Boolean)this.field_6011.method_12789(BURIED);
    }

    public void setBuried(boolean buried) {
        this.field_6011.method_12778(BURIED, (Object)buried);
    }

    public boolean isSpawnedByBoss() {
        return (Boolean)this.field_6011.method_12789(SPAWNED_BY_BOSS);
    }

    public void setSpawnedByBoss(boolean spawned) {
        this.field_6011.method_12778(SPAWNED_BY_BOSS, (Object)spawned);
        this.updateAttributeModifiers();
    }

    @Override
    protected class_3414 method_6002() {
        return MineCellsSounds.SEWERS_TENTACLE_DEATH;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("variant", this.getVariant());
        nbt.method_10556("buried", this.isBuried());
        nbt.method_10556("spawnedByBoss", this.isSpawnedByBoss());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(nbt.method_10550("variant"));
        this.setBuried(nbt.method_10577("buried"));
        this.setSpawnedByBoss(nbt.method_10577("spawnedByBoss"));
    }

    static {
        bossModifiers.put((Object)class_5134.field_23724, (Object)new class_1322(MineCells.createId("boss_armor"), 5.0, class_1322.class_1323.field_6328));
        bossModifiers.put((Object)class_5134.field_23721, (Object)new class_1322(MineCells.createId("boss_damage"), 4.0, class_1322.class_1323.field_6328));
        bossModifiers.put((Object)class_5134.field_23719, (Object)new class_1322(MineCells.createId("boss_speed"), 0.05, class_1322.class_1323.field_6328));
    }

    public static class TentacleAttackGoal
    extends class_1366 {
        private int ticks = 0;
        private boolean attacking = false;

        public TentacleAttackGoal(SewersTentacleEntity mob, double speed) {
            super((class_1314)mob, speed, true);
        }

        public void method_6268() {
            if (this.attacking) {
                if (this.ticks > 15) {
                    ((SewersTentacleEntity)this.field_6503).setBuried(false);
                    for (class_1657 player : this.field_6503.method_37908().method_18464(class_4051.field_18092, (class_1309)this.field_6503, this.field_6503.method_5829().method_1009(0.75, 0.0, 0.75))) {
                        this.method_6288((class_1309)player);
                    }
                    if (this.ticks > 80) {
                        this.attacking = false;
                    }
                }
                ++this.ticks;
            } else {
                int maxBuriedTicks;
                ((SewersTentacleEntity)this.field_6503).setBuried(true);
                int n = maxBuriedTicks = ((SewersTentacleEntity)this.field_6503).isSpawnedByBoss() ? 40 : 20;
                if (((SewersTentacleEntity)this.field_6503).buriedTicks > maxBuriedTicks && this.field_6503.method_5968() != null) {
                    double x = this.field_6503.method_5968().method_23317() + (this.field_6503.method_59922().method_43058() - 0.5) * 3.0;
                    double z = this.field_6503.method_5968().method_23321() + (this.field_6503.method_59922().method_43058() - 0.5) * 3.0;
                    this.field_6503.method_5962().method_6239(x, this.field_6503.method_5968().method_23318(), z, 1.0);
                    if ((double)this.field_6503.method_5968().method_5739((class_1297)this.field_6503) <= 1.0) {
                        this.field_6503.method_5783(MineCellsSounds.CHARGE, 1.0f, 1.0f);
                        this.attacking = true;
                        this.ticks = 0;
                    }
                }
            }
        }

        protected void method_6288(class_1309 target) {
            if (this.attacking) {
                float damage = (float)this.field_6503.method_45325(class_5134.field_23721);
                target.method_5643(target.method_48923().method_48812((class_1309)this.field_6503), damage);
                class_243 diffNorm = this.field_6503.method_19538().method_1020(target.method_19538()).method_1029();
                target.method_6005(1.0, diffNorm.field_1352, diffNorm.field_1350);
            }
        }

        public void method_6270() {
            super.method_6270();
            this.ticks = 0;
            this.attacking = false;
            ((SewersTentacleEntity)this.field_6503).setBuried(true);
        }
    }

    public static class TentacleSweepGoal
    extends TimedDashGoal<SewersTentacleEntity> {
        public TentacleSweepGoal(SewersTentacleEntity entity, Consumer<TimedDashGoal.TimedDashSettings> settingsConsumer) {
            super(entity, settingsConsumer, (E e) -> e.method_5968() != null && Math.abs(e.method_5968().method_23318() - e.method_23318()) < (double)0.1f && e.buriedTicks > 60 && (e.method_5858((class_1297)e.method_5968()) > 16.0 || e.isSpawnedByBoss()));
        }

        @Override
        protected boolean shouldSlowDown() {
            return this.distanceTravelled > 1.25 * this.targetDistance;
        }

        @Override
        public boolean method_6266() {
            return super.method_6266() && !this.shouldSlowDown() && ((SewersTentacleEntity)this.entity).field_6017 == 0.0f && !((SewersTentacleEntity)this.entity).field_5976;
        }
    }
}

