/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.screen.cellcrafter;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.client.gui.toast.SurfaceUtil;
import com.github.mim1q.minecells.network.ServerPacketHandler;
import com.github.mim1q.minecells.network.c2s.CellCrafterCraftRequestC2SPacket;
import com.github.mim1q.minecells.network.c2s.RequestUnlockedCellCrafterRecipesC2SPacket;
import com.github.mim1q.minecells.recipe.CellForgeRecipe;
import com.github.mim1q.minecells.recipe.PlayerInventoryInput;
import com.github.mim1q.minecells.screen.cellcrafter.CellCrafterRecipeList;
import com.github.mim1q.minecells.screen.cellcrafter.CellCrafterScreenHandler;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.jetbrains.annotations.NotNull;

public class CellCrafterScreen
extends BaseOwoHandledScreen<FlowLayout, CellCrafterScreenHandler> {
    public static final class_2960 SCREEN_TEXTURE = MineCells.createId("textures/gui/cell_crafter/container.png");
    private final CellCrafterRecipeList recipeList = new CellCrafterRecipeList(this);
    private final TexturedButton forgeButton;
    private boolean isRecipeListVisible = false;
    private CellForgeRecipe selectedRecipe = null;
    private class_2338 blockPos = null;

    public CellCrafterScreen(CellCrafterScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        ServerPacketHandler.CHANNEL.clientHandle().send((Record)new RequestUnlockedCellCrafterRecipesC2SPacket(inventory.field_7546.method_5628()));
        handler.blockPos.observe(it -> {
            this.blockPos = it;
        });
        this.forgeButton = new TexturedButton(it -> {
            if (this.selectedRecipe != null && this.blockPos != null) {
                ServerPacketHandler.CHANNEL.clientHandle().send((Record)new CellCrafterCraftRequestC2SPacket(this.selectedRecipe.id(), this.blockPos));
            }
        }, SCREEN_TEXTURE, 208, 0);
    }

    public void updateRecipes(List<CellCrafterRecipeList.DisplayedRecipe> recipes) {
        this.recipeList.updateRecipes(recipes);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        if (this.isRecipeListVisible) {
            this.recipeList.build(rootComponent);
        } else {
            FlowLayout container = Containers.verticalFlow((Sizing)Sizing.fixed((int)178), (Sizing)Sizing.fixed((int)160));
            container.surface(SurfaceUtil.backgroundTexture(SCREEN_TEXTURE, 178, 160)).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.TOP).padding(Insets.of((int)8));
            container.child(new TexturedButton(it -> this.toggleRecipeList(), SCREEN_TEXTURE, 192, 48).sizing(Sizing.fixed((int)64)).tooltip((class_2561)class_2561.method_43471((String)"block.minecells.cell_crafter.view_recipes")));
            if (this.selectedRecipe != null) {
                container.child(Components.texture((class_2960)SCREEN_TEXTURE, (int)224, (int)0, (int)16, (int)16).sizing(Sizing.fixed((int)16)).positioning(Positioning.absolute((int)100, (int)26)));
                container.child(this.forgeButton.sizing(Sizing.fixed((int)16)).positioning(Positioning.absolute((int)118, (int)26)));
                container.child(Components.item((class_1799)this.selectedRecipe.output()).showOverlay(true).sizing(Sizing.fixed((int)16)).positioning(Positioning.absolute((int)100, (int)44)).tooltip((Collection)this.selectedRecipe.output().method_7950(class_1792.class_9635.field_51353, ((CellCrafterScreenHandler)this.field_2797).player(), (class_1836)class_1836.field_41070)));
                container.child((Component)new IngredientDisplay(((CellCrafterScreenHandler)this.field_2797).player().method_31548(), this.selectedRecipe, Sizing.fixed((int)96), Sizing.fixed((int)16)).positioning(Positioning.absolute((int)60, (int)6)));
            }
            rootComponent.child((Component)container);
        }
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        this.forgeButton.active(this.selectedRecipe != null && this.selectedRecipe.matches(new PlayerInventoryInput(((CellCrafterScreenHandler)this.field_2797).player().method_31548()), ((CellCrafterScreenHandler)this.field_2797).player().method_37908()));
        this.forgeButton.tooltip((class_2561)(this.forgeButton.field_22763 ? class_2561.method_43471((String)"block.minecells.cell_crafter.craft") : class_2561.method_43471((String)"block.minecells.cell_crafter.not_enough_ingredients")));
    }

    public void rebuild() {
        if (this.uiAdapter == null) {
            return;
        }
        ((FlowLayout)this.uiAdapter.rootComponent).clearChildren();
        this.build((FlowLayout)this.uiAdapter.rootComponent);
    }

    public void toggleRecipeList() {
        this.isRecipeListVisible = !this.isRecipeListVisible;
        for (int i = 0; i < 36; ++i) {
            if (this.isRecipeListVisible) {
                this.disableSlot(i);
                continue;
            }
            this.enableSlot(i);
        }
        this.rebuild();
        this.recipeList.clearSearch();
    }

    public void setSelectedRecipe(CellForgeRecipe recipe) {
        this.selectedRecipe = recipe;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (verticalAmount > 0.0) {
            this.recipeList.scrollUp();
        } else if (verticalAmount < 0.0) {
            this.recipeList.scrollDown();
        }
        return true;
    }

    public void method_25419() {
        if (this.isRecipeListVisible) {
            this.toggleRecipeList();
        } else {
            super.method_25419();
        }
    }

    public static class TexturedButton
    extends ButtonComponent {
        protected TexturedButton(Consumer<ButtonComponent> onPress, class_2960 texture, int u, int v) {
            super((class_2561)class_2561.method_43473(), onPress);
            this.renderer = ButtonComponent.Renderer.texture((class_2960)texture, (int)u, (int)v, (int)256, (int)256);
        }
    }

    public static class IngredientDisplay
    extends FlowLayout {
        private final CellForgeRecipe recipe;
        private final class_1661 inventory;
        private final Map<class_1799, class_3545<ItemComponent, LabelComponent>> itemLabels = new HashMap<class_1799, class_3545<ItemComponent, LabelComponent>>();

        public IngredientDisplay(class_1661 inventory, CellForgeRecipe recipe, Sizing horizontalSizing, Sizing verticalSizing) {
            super(horizontalSizing, verticalSizing, FlowLayout.Algorithm.HORIZONTAL);
            this.inventory = inventory;
            this.recipe = recipe;
            this.horizontalAlignment(HorizontalAlignment.CENTER);
            this.allowOverflow(true);
            this.setup();
        }

        public void setup() {
            this.clearChildren();
            for (Map.Entry<class_1792, Integer> ingredient : this.recipe.ingredients().entrySet()) {
                class_1799 itemStack = ingredient.getKey().method_7854();
                FlowLayout box = Containers.horizontalFlow((Sizing)Sizing.fixed((int)16), (Sizing)Sizing.fixed((int)16));
                box.allowOverflow(true);
                ItemComponent itemComponent = Components.item((class_1799)itemStack);
                itemComponent.sizing(Sizing.fixed((int)16)).tooltip(this.tooltip);
                box.child((Component)itemComponent);
                LabelComponent label = Components.label((class_2561)class_2561.method_43470((String)String.valueOf(ingredient.getValue())));
                label.shadow(true).horizontalTextAlignment(HorizontalAlignment.CENTER).positioning(Positioning.absolute((int)6, (int)10)).horizontalSizing(Sizing.fixed((int)16)).zIndex(300);
                box.child((Component)label);
                this.itemLabels.put(itemStack.method_46651(ingredient.getValue().intValue()), (class_3545<ItemComponent, LabelComponent>)new class_3545((Object)itemComponent, (Object)label));
                this.child((Component)box);
            }
            this.updateLabels();
        }

        private void updateLabels() {
            for (Map.Entry<class_1799, class_3545<ItemComponent, LabelComponent>> entry : this.itemLabels.entrySet()) {
                int color;
                boolean hasEnough;
                class_2561 sibling;
                class_1799 ingredient = entry.getKey();
                List tooltip = ingredient.method_7950(class_1792.class_9635.field_51353, (class_1657)class_310.method_1551().field_1724, (class_1836)class_1836.field_41070);
                ItemComponent itemComponent = (ItemComponent)entry.getValue().method_15442();
                LabelComponent label = (LabelComponent)entry.getValue().method_15441();
                class_2561 firstLine = (class_2561)tooltip.get(0);
                if (firstLine != null && (sibling = (class_2561)firstLine.method_10855().get(0)) != null) {
                    class_5250 text = class_5250.method_43477((class_7417)sibling.method_10851());
                    text.method_27693(" x" + ingredient.method_7947());
                    tooltip.clear();
                    tooltip.add(firstLine);
                    firstLine.method_10855().set(0, text);
                }
                boolean bl = hasEnough = this.inventory == null || this.inventory.method_18861(ingredient.method_7909()) >= ingredient.method_7947();
                if (!hasEnough) {
                    tooltip.addAll(class_2561.method_43471((String)"block.minecells.cell_crafter.not_enough_of_this_item").method_36136(class_2583.field_24360.method_36139(0xFF0000)));
                }
                int n = color = hasEnough ? 0x99FFA9 : 16743293;
                if (this.inventory == null) {
                    color = 0xFFFFFF;
                }
                itemComponent.tooltip((Collection)tooltip);
                label.color(Color.ofArgb((int)color));
            }
        }

        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            this.updateLabels();
            super.draw(context, mouseX, mouseY, partialTicks, delta);
        }
    }
}

