/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.world.placement;

import com.github.mim1q.minecells.world.feature.MineCellsStructurePlacementTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2382;
import net.minecraft.class_2919;
import net.minecraft.class_5321;
import net.minecraft.class_5381;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6873;
import net.minecraft.class_6874;
import net.minecraft.class_6875;
import net.minecraft.class_6880;
import net.minecraft.class_7059;
import net.minecraft.class_7869;
import net.minecraft.class_7924;

public class BetterRandomSpreadPlacement
extends class_6874 {
    public static final MapCodec<BetterRandomSpreadPlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2382.method_39677((int)16).optionalFieldOf("locate_offset", (Object)class_2382.field_11176).forGetter(rec$ -> ((BetterRandomSpreadPlacement)((Object)((Object)((Object)rec$)))).method_41642()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(rec$ -> Float.valueOf(((BetterRandomSpreadPlacement)((Object)((Object)((Object)rec$)))).method_41644())), (App)class_5699.field_33441.fieldOf("salt").forGetter(rec$ -> ((BetterRandomSpreadPlacement)((Object)((Object)((Object)rec$)))).method_41645()), (App)BetterExclusionZone.CODEC.listOf().optionalFieldOf("exclusion_zones", List.of()).forGetter(BetterRandomSpreadPlacement::getExclusionZones), (App)class_5699.field_33441.fieldOf("minecells_spacing").forGetter(it -> it.spacing), (App)class_5699.field_33441.fieldOf("minecells_separation").forGetter(it -> it.separation), (App)class_6873.field_36423.optionalFieldOf("spread_type", (Object)class_6873.field_36421).forGetter(it -> it.spreadType)).apply((Applicative)instance, BetterRandomSpreadPlacement::new));
    private final List<BetterExclusionZone> exclusionZones;
    private final float actualFrequency;
    private final int spacing;
    private final int separation;
    private final class_6873 spreadType;

    private BetterRandomSpreadPlacement(class_2382 locateOffset, float frequency, int salt, List<BetterExclusionZone> exclusionZones, int spacing, int separation, class_6873 spreadType) {
        super(locateOffset, class_6874.class_7154.field_37782, 1.0f, salt, Optional.empty());
        this.exclusionZones = exclusionZones;
        this.actualFrequency = frequency;
        this.spacing = spacing;
        this.separation = separation;
        this.spreadType = spreadType;
    }

    private List<BetterExclusionZone> getExclusionZones() {
        return this.exclusionZones;
    }

    public boolean method_41639(class_7869 calculator, int chunkX, int chunkZ) {
        boolean result = super.method_41639(calculator, chunkX, chunkZ);
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(0L));
        chunkRandom.method_12663(calculator.method_46714() + (long)this.method_41645(), chunkX, chunkZ);
        return result && chunkRandom.method_43057() <= this.actualFrequency && this.exclusionZones.stream().noneMatch(zone -> zone.shouldExclude(calculator, chunkX, chunkZ));
    }

    public class_1923 getStartChunk(long seed, int chunkX, int chunkZ) {
        int i = Math.floorDiv(chunkX, this.spacing);
        int j = Math.floorDiv(chunkZ, this.spacing);
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(0L));
        chunkRandom.method_12665(seed, i, j, this.method_41645());
        int k = this.spacing - this.separation;
        int l = this.spreadType.method_40173((class_5819)chunkRandom, k);
        int m = this.spreadType.method_40173((class_5819)chunkRandom, k);
        return new class_1923(i * this.spacing + l, j * this.spacing + m);
    }

    protected boolean method_40168(class_7869 calculator, int chunkX, int chunkZ) {
        class_1923 chunkPos = this.getStartChunk(calculator.method_46714(), chunkX, chunkZ);
        return chunkPos.field_9181 == chunkX && chunkPos.field_9180 == chunkZ;
    }

    public class_6875<?> method_40166() {
        return MineCellsStructurePlacementTypes.BETTER_RANDOM_SPREAD;
    }

    private static class BetterExclusionZone {
        public static final Codec<BetterExclusionZone> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5381.method_31192((class_5321)class_7924.field_41248, (Codec)class_7059.field_37195, (boolean)false).fieldOf("other_set").forGetter(it -> it.otherSet), (App)Codec.intRange((int)1, (int)32).fieldOf("chunk_count").forGetter(it -> it.chunkCount)).apply((Applicative)instance, BetterExclusionZone::new));
        private final class_6880<class_7059> otherSet;
        private final int chunkCount;

        public BetterExclusionZone(class_6880<class_7059> registryEntry, int i) {
            this.otherSet = registryEntry;
            this.chunkCount = i;
        }

        boolean shouldExclude(class_7869 calculator, int x, int z) {
            return calculator.method_46709(this.otherSet, x, z, this.chunkCount);
        }
    }
}

