/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MockItemRenderer {
    private static final Map<ResourceLocation, Boolean[][]> CACHE = new HashMap<ResourceLocation, Boolean[][]>();
    public static final float DEFAULT_THICKNESS = 0.065f;

    public static void renderItem(PoseStack poseStack, MultiBufferSource bufferSource, int light, ResourceLocation texture) {
        MockItemRenderer.renderTintedItem(poseStack, bufferSource, light, texture, 0xFFFFFF);
    }

    public static void renderTintedItem(PoseStack poseStack, MultiBufferSource bufferSource, int light, ResourceLocation texture, int tint) {
        int red = tint >> 16 & 0xFF;
        int green = tint >> 8 & 0xFF;
        int blue = tint & 0xFF;
        MockItemRenderer.renderTintedItem(poseStack, bufferSource, light, texture, red, green, blue);
    }

    public static void renderTintedItem(PoseStack poseStack, MultiBufferSource bufferSource, int light, ResourceLocation texture, int red, int green, int blue) {
        Boolean[][] pixelData = MockItemRenderer.loadPixelData(texture, 16);
        MockItemRenderer.renderItem(pixelData, poseStack, bufferSource, light, texture, 0.065f, red, green, blue);
    }

    public static void renderItem(Boolean[][] pixelData, PoseStack poseStack, MultiBufferSource bufferSource, int light, ResourceLocation texture, float thickness, int red, int green, int blue) {
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)texture));
        poseStack.m_85836_();
        float halfZ = thickness * 0.5f;
        int width = pixelData.length;
        int height = width > 0 ? pixelData[0].length : 0;
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        MockItemRenderer.renderItem(pixelData, buffer, pose, normal, halfZ, light, width, height, red, green, blue);
        poseStack.m_85849_();
    }

    private static void renderItem(Boolean[][] pixelData, VertexConsumer buffer, Matrix4f pose, Matrix3f normal, float halfZ, int light, int width, int height, int red, int green, int blue) {
        MockItemRenderer.addQuad(buffer, pose, normal, 0.0f, 0.0f, halfZ, 1.0f, 0.0f, halfZ, 1.0f, 1.0f, halfZ, 0.0f, 1.0f, halfZ, MockItemRenderer.computeUV(0.0f, 0.0f, 1.0f, 1.0f), MockItemRenderer.computeUV(1.0f, 0.0f, 1.0f, 1.0f), MockItemRenderer.computeUV(1.0f, 1.0f, 1.0f, 1.0f), MockItemRenderer.computeUV(0.0f, 1.0f, 1.0f, 1.0f), light, 0.0f, 0.0f, 1.0f, red, green, blue);
        MockItemRenderer.addQuad(buffer, pose, normal, 1.0f, 0.0f, -halfZ, 0.0f, 0.0f, -halfZ, 0.0f, 1.0f, -halfZ, 1.0f, 1.0f, -halfZ, MockItemRenderer.computeUV(1.0f, 0.0f, 1.0f, 1.0f), MockItemRenderer.computeUV(0.0f, 0.0f, 1.0f, 1.0f), MockItemRenderer.computeUV(0.0f, 1.0f, 1.0f, 1.0f), MockItemRenderer.computeUV(1.0f, 1.0f, 1.0f, 1.0f), light, 0.0f, 0.0f, -1.0f, red, green, blue);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                float[][] sideUV;
                Boolean pd = pixelData[x][y];
                if (!pd.booleanValue()) continue;
                float scaledX = (float)x / (float)width;
                float scaledY = (float)y / (float)height;
                float scaledXNext = (float)(x + 1) / (float)width;
                float scaledYNext = (float)(y + 1) / (float)height;
                if (x == 0 || !pixelData[x - 1][y].booleanValue()) {
                    sideUV = MockItemRenderer.computeVerticalSliceUV(x, y, y + 1, width, height);
                    MockItemRenderer.addQuad(buffer, pose, normal, scaledX, scaledYNext, halfZ, scaledX, scaledYNext, -halfZ, scaledX, scaledY, -halfZ, scaledX, scaledY, halfZ, sideUV[0], sideUV[1], sideUV[2], sideUV[3], light, -1.0f, 0.0f, 0.0f, red, green, blue);
                }
                if (x == width - 1 || !pixelData[x + 1][y].booleanValue()) {
                    sideUV = MockItemRenderer.computeVerticalSliceUV(x, y, y + 1, width, height);
                    MockItemRenderer.addQuad(buffer, pose, normal, scaledXNext, scaledYNext, -halfZ, scaledXNext, scaledYNext, halfZ, scaledXNext, scaledY, halfZ, scaledXNext, scaledY, -halfZ, sideUV[0], sideUV[1], sideUV[2], sideUV[3], light, 1.0f, 0.0f, 0.0f, red, green, blue);
                }
                if (y == 0 || !pixelData[x][y - 1].booleanValue()) {
                    sideUV = MockItemRenderer.computeHorizontalSliceUV(x, x + 1, y, width, height);
                    MockItemRenderer.addQuad(buffer, pose, normal, scaledXNext, scaledY, -halfZ, scaledXNext, scaledY, halfZ, scaledX, scaledY, halfZ, scaledX, scaledY, -halfZ, sideUV[0], sideUV[1], sideUV[2], sideUV[3], light, 0.0f, -1.0f, 0.0f, red, green, blue);
                }
                if (y != height - 1 && pixelData[x][y + 1].booleanValue()) continue;
                sideUV = MockItemRenderer.computeHorizontalSliceUV(x, x + 1, y, width, height);
                MockItemRenderer.addQuad(buffer, pose, normal, scaledXNext, scaledYNext, halfZ, scaledXNext, scaledYNext, -halfZ, scaledX, scaledYNext, -halfZ, scaledX, scaledYNext, halfZ, sideUV[0], sideUV[1], sideUV[2], sideUV[3], light, 0.0f, 1.0f, 0.0f, red, green, blue);
            }
        }
    }

    private static float[] computeUV(float x, float y, float width, float height) {
        float u = x / width;
        float v = y / height;
        return new float[]{u, v};
    }

    private static float[][] computeVerticalSliceUV(float x, float y0, float y1, float width, float height) {
        float u0 = x / width;
        float u1 = (x + 1.0f) / width;
        float v0 = y0 / height;
        float v1 = y1 / height;
        return new float[][]{{u0, v0}, {u1, v0}, {u1, v1}, {u0, v1}};
    }

    private static float[][] computeHorizontalSliceUV(float x0, float x1, float y, float width, float height) {
        float u0 = x0 / width;
        float u1 = x1 / width;
        float v0 = y / height;
        float v1 = (y + 1.0f) / height;
        return new float[][]{{u0, v0}, {u1, v0}, {u1, v1}, {u0, v1}};
    }

    private static void addQuad(VertexConsumer buffer, Matrix4f pose, Matrix3f normalMatrix, float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float[] uv0, float[] uv1, float[] uv2, float[] uv3, int light, float nx, float ny, float nz, int r, int g, int b) {
        buffer.m_252986_(pose, x0, y0, z0).m_6122_(r, g, b, 255).m_7421_(uv0[0], uv0[1]).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, nx, ny, nz).m_5752_();
        buffer.m_252986_(pose, x1, y1, z1).m_6122_(r, g, b, 255).m_7421_(uv1[0], uv1[1]).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, nx, ny, nz).m_5752_();
        buffer.m_252986_(pose, x2, y2, z2).m_6122_(r, g, b, 255).m_7421_(uv2[0], uv2[1]).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, nx, ny, nz).m_5752_();
        buffer.m_252986_(pose, x3, y3, z3).m_6122_(r, g, b, 255).m_7421_(uv3[0], uv3[1]).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, nx, ny, nz).m_5752_();
    }

    public static Boolean[][] loadPixelData(ResourceLocation texture, int alphaThreshold) {
        Boolean[][] booleanArray;
        block11: {
            if (CACHE.containsKey(texture)) {
                return CACHE.get(texture);
            }
            Resource resource = (Resource)Minecraft.m_91087_().m_91098_().m_213713_(texture).orElseThrow();
            InputStream input = resource.m_215507_();
            try {
                BufferedImage image = ImageIO.read(input);
                int width = image.getWidth();
                int height = image.getHeight();
                Boolean[][] pixelData = new Boolean[width][height];
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        int argb = image.getRGB(x, y);
                        int alpha = argb >> 24 & 0xFF;
                        pixelData[x][y] = alpha >= alphaThreshold;
                    }
                }
                CACHE.putIfAbsent(texture, pixelData);
                booleanArray = pixelData;
                if (input == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read image: " + String.valueOf(texture), e);
                }
            }
            input.close();
        }
        return booleanArray;
    }
}

