/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp.mixin.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.infernalstudios.archeryexp.common.entities.ArcheryEntityTypes;
import org.infernalstudios.archeryexp.util.ArcheryEnchantUtil;
import org.infernalstudios.archeryexp.util.BowUtil;
import org.infernalstudios.archeryexp.util.json.data.BowEffectData;
import org.infernalstudios.archeryexp.util.json.data.BowParticleData;
import org.infernalstudios.archeryexp.util.mixinterfaces.IArrowProperties;
import org.infernalstudios.archeryexp.util.mixinterfaces.IBowProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BowItem.class})
public abstract class BowItemMixin
implements IBowProperties {
    @Unique
    private List<BowEffectData> archeryexp$effects = new ArrayList<BowEffectData>();
    @Unique
    private List<BowParticleData> archeryexp$particles = new ArrayList<BowParticleData>();
    @Unique
    private int archeryexp$cooldown;
    @Unique
    private int archeryexp$drawTime;
    @Unique
    private float archeryexp$range;
    @Unique
    private float archeryexp$baseDamage;
    @Unique
    private float archeryexp$breakingResistance;
    @Unique
    private float archeryexp$breakChance;
    @Unique
    private float archeryexp$walkSpeed;
    @Unique
    private float archeryexp$recoil;
    @Unique
    private float archeryexp$offsetX;
    @Unique
    private float archeryexp$offsetY;
    @Unique
    private boolean archeryexp$special;
    @Unique
    private boolean archeryexp$hasDescText = true;

    @Inject(method={"releaseUsing"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void archeryexp$releaseUsing(ItemStack stack, Level world, LivingEntity entity, int remainingUseTicks, CallbackInfo ci, Player user, boolean $$5, ItemStack $$6, int $$7, float $$8, boolean $$9, ArrowItem arrowItem, AbstractArrow arrow) {
        BowItem bow = (BowItem)this;
        ArcheryEnchantUtil.enchantmentAction(() -> Enchantments.f_44988_, (LivingEntity)user, stack, true, lvl -> stack.m_41622_(lvl, (LivingEntity)user, ignore -> {}));
        if (this.archeryexp$special) {
            float shoot = BowUtil.getPowerForDrawTime($$7, this);
            arrow.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, shoot * this.archeryexp$getRange(), 1.0f);
            double damage = this.archeryexp$checkModdedArrow((Entity)arrow, "caverns_and_chasms:large_arrow") ? (double)this.archeryexp$getBaseDamage() + 4.0 : (double)this.archeryexp$getBaseDamage();
            arrow.m_36781_(damage);
            ArcheryEnchantUtil.enchantmentAction(() -> Enchantments.f_44988_, (LivingEntity)user, stack, true, lvl -> arrow.m_36781_(arrow.m_36789_() + (double)lvl * 0.5 + 0.5));
            arrow.m_36762_(shoot == 1.0f);
            ((IArrowProperties)arrow).archeryexp$setShatterLevel(stack);
            ((IArrowProperties)arrow).archeryexp$setHeadshotLevel(stack);
            this.archeryexp$effects.forEach(effect -> effect.apply((LivingEntity)user));
            this.archeryexp$particles.forEach(particle -> particle.apply((LivingEntity)user));
            user.m_36335_().m_41524_((Item)bow, this.archeryexp$getBowCooldown());
            this.archeryexp$applyRecoil(user, this.archeryexp$getRecoil());
            if (stack.m_150930_(Items.f_42411_) && (float)user.m_217043_().m_188503_(100) < this.archeryexp$oldBowBreakChance(arrow)) {
                stack.m_41622_(stack.m_41776_(), (LivingEntity)user, player -> player.m_21190_(player.m_7655_()));
            }
        }
    }

    @Unique
    private float archeryexp$oldBowBreakChance(AbstractArrow arrow) {
        EntityType type = arrow.m_6095_();
        if (type == EntityType.f_20548_) {
            return 0.0f;
        }
        if (type == ArcheryEntityTypes.GOLD_ARROW) {
            return 10.0f;
        }
        if (type == ArcheryEntityTypes.IRON_ARROW) {
            return 20.0f;
        }
        if (type == ArcheryEntityTypes.DIAMOND_ARROW) {
            return 40.0f;
        }
        if (type == ArcheryEntityTypes.NETHERITE_ARROW) {
            return 60.0f;
        }
        return 12.0f;
    }

    @Unique
    private void archeryexp$applyRecoil(Player user, double amount) {
        Vec3 lookDirection = user.m_20252_(1.0f);
        Vec3 knockbackVector = lookDirection.m_82542_(-amount, -amount, -amount);
        user.m_20334_(user.m_20184_().f_82479_ + knockbackVector.f_82479_, user.m_20184_().f_82480_ + knockbackVector.f_82480_, user.m_20184_().f_82481_ + knockbackVector.f_82481_);
        user.f_19864_ = true;
    }

    @Unique
    public boolean archeryexp$checkModdedArrow(Entity entity, String entityId) {
        return BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()).equals((Object)new ResourceLocation(entityId));
    }

    @Override
    public int archeryexp$getBowCooldown() {
        return this.archeryexp$cooldown;
    }

    @Override
    public void archeryexp$setBowCooldown(int cooldown) {
        this.archeryexp$cooldown = cooldown;
    }

    @Override
    public float archeryexp$getBaseDamage() {
        return this.archeryexp$baseDamage;
    }

    @Override
    public void archeryexp$setBaseDamage(float baseDamage) {
        this.archeryexp$baseDamage = baseDamage;
    }

    @Override
    public float archeryexp$getRange() {
        return this.archeryexp$range;
    }

    @Override
    public void archeryexp$setRange(float range) {
        this.archeryexp$range = range;
    }

    @Override
    public int archeryexp$getChargeTime() {
        return this.archeryexp$drawTime;
    }

    @Override
    public void archeryexp$setChargeTime(int chargeTime) {
        this.archeryexp$drawTime = chargeTime;
    }

    @Override
    public boolean archeryexp$isSpecial() {
        return this.archeryexp$special;
    }

    @Override
    public void archeryexp$setSpecial(boolean hasProperties) {
        this.archeryexp$special = hasProperties;
    }

    @Override
    public void archeryexp$setBreakResist(float breakResist) {
        this.archeryexp$breakingResistance = breakResist;
    }

    @Override
    public float archeryexp$getBreakResist() {
        return !this.archeryexp$special ? 1.0f : this.archeryexp$breakingResistance;
    }

    @Override
    public float archeryexp$getWalkSpeed() {
        return this.archeryexp$walkSpeed;
    }

    @Override
    public void archeryexp$setWalkSpeed(float walkSpeed) {
        this.archeryexp$walkSpeed = walkSpeed;
    }

    @Override
    public List<BowEffectData> archeryexp$getEffects() {
        return this.archeryexp$effects;
    }

    @Override
    public void archeryexp$setEffects(List<BowEffectData> effects) {
        this.archeryexp$effects = effects;
    }

    @Override
    public List<BowParticleData> archeryexp$getParticles() {
        return this.archeryexp$particles;
    }

    @Override
    public void archeryexp$setParticles(List<BowParticleData> particles) {
        this.archeryexp$particles = particles;
    }

    @Override
    public float archeryexp$getRecoil() {
        return this.archeryexp$recoil;
    }

    @Override
    public void archeryexp$setRecoil(float recoil) {
        this.archeryexp$recoil = recoil;
    }

    @Override
    public float archeryexp$getBreakChance() {
        return this.archeryexp$breakChance;
    }

    @Override
    public void archeryexp$setBreakChance(float breakChance) {
        this.archeryexp$breakChance = breakChance;
    }

    @Override
    public float archeryexp$getOffsetX() {
        return this.archeryexp$offsetX;
    }

    @Override
    public void archeryexp$setOffsetX(float x) {
        this.archeryexp$offsetX = x;
    }

    @Override
    public float archeryexp$getOffsetY() {
        return this.archeryexp$offsetY;
    }

    @Override
    public void archeryexp$setOffsetY(float y) {
        this.archeryexp$offsetY = y;
    }

    @Override
    public boolean archeryexp$hasDesc() {
        return this.archeryexp$hasDescText;
    }

    @Override
    public void archeryexp$setHasDesc(boolean hasDescText) {
        this.archeryexp$hasDescText = hasDescText;
    }
}

