/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.archeryexp.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.infernalstudios.archeryexp.util.mixinterfaces.IBowProperties;

public class BowUtil {
    public static List<Vec3> getBowTrajectoryPoints(Player player, IBowProperties bow) {
        int steps = 200;
        List<Vec3> trajectoryPoints = bow.archeryexp$isSpecial() ? BowUtil.calculateTrajectory((LivingEntity)player, player.m_7655_(), BowUtil.getPowerForDrawTime(player.m_21211_().m_41779_() - player.m_21212_(), bow), bow.archeryexp$getRange(), -player.m_146908_() - 90.0f, player.m_146909_(), 0.05f, steps) : BowUtil.calculateTrajectory((LivingEntity)player, player.m_7655_(), BowItem.m_40661_((int)(player.m_21211_().m_41779_() - player.m_21212_())), 3.0f, -player.m_146908_() - 90.0f, player.m_146909_(), 0.05f, steps);
        return trajectoryPoints;
    }

    private static List<Vec3> calculateTrajectory(LivingEntity user, InteractionHand hand, float power, float range, float yaw, float pitch, float gravity, int steps) {
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        Vec3 startPosition = user.m_20299_(1.0f);
        Vec3 direction = BowUtil.getDirectionVector(yaw, pitch).m_82490_((double)(power * range));
        Vec3 position = startPosition;
        Vec3 velocity = direction;
        float defaultDrag = 0.99f;
        float waterDrag = 0.8f;
        for (int i = 0; i < steps; ++i) {
            if (position.m_82554_(startPosition) >= 1.0 && (points.isEmpty() || ((Vec3)points.get(points.size() - 1)).m_82554_(position) >= 1.0)) {
                points.add(position);
            }
            velocity = user.m_9236_().m_8055_(new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_)).m_60713_(Blocks.f_49990_) ? velocity.m_82490_((double)waterDrag) : velocity.m_82490_((double)defaultDrag);
            position = position.m_82549_(velocity);
            velocity = velocity.m_82520_(0.0, (double)(-gravity), 0.0);
            if (position.f_82480_ < -64.0) break;
        }
        return points;
    }

    private static Vec3 getDirectionVector(float yaw, float pitch) {
        float radYaw = -yaw * ((float)Math.PI / 180);
        float radPitch = -pitch * ((float)Math.PI / 180);
        float x = Mth.m_14089_((float)radPitch) * Mth.m_14089_((float)radYaw);
        float y = Mth.m_14031_((float)radPitch);
        float z = Mth.m_14089_((float)radPitch) * Mth.m_14031_((float)radYaw);
        return new Vec3((double)x, (double)y, (double)z);
    }

    public static float getPowerForDrawTime(int drawTime, IBowProperties stack) {
        float power = (float)drawTime / (float)stack.archeryexp$getChargeTime();
        if ((power = (power * power + power * 2.0f) / 3.0f) > 1.0f) {
            power = 1.0f;
        }
        return power;
    }
}

